/* filename: ATPGRID.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <tzprint.h>

void AtPrintGrid(int ULCol, int ULRow, int LRCol, int LRRow,
int LineStyle, int NHorizontal, int NVertical)
{
  char *SymbolSet[5] =
  {"\xDA\xC4\xC4\xBF\xB3\xC0\xD9\xC5\xC2\xC1\xB4\xC3", // single line box chars
    "\xC9\xCD\xCD\xBB\xBA\xC8\xBC\xCE\xCB\xCA\xB9\xCC", // double line box chars
    "\xDB\xDC\xDF\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB", // solid line box chars
    "\xD6\xC4\xC4\xB7\xBA\xD3\xBD\xD7\xD2\xD0\xB6\xC7", // double sides, single top/bottom
  "\xD5\xCD\xCD\xB8\xB3\xD4\xBE\xD8\xD1\xCF\xB5\xC6"}; // single sides, double top/bottom
  int col, row;
  int horizontalOffset, verticalOffset;
  int i, j;
  char *ss;

  // Checking for valid conditions
  if ((ULCol > LRCol) || (ULRow > LRRow))
    return;
  if ((LineStyle < 1) || (LineStyle > 5))
    LineStyle = 1;

  MakePageBuffer();

  ss = SymbolSet[LineStyle-1];

  // First, draw the outside box corners
  PutChar(ULCol,ULRow,ss[TLCorner]);
  PutChar(LRCol,ULRow,ss[TRCorner]);
  PutChar(ULCol,LRRow,ss[BLCorner]);
  PutChar(LRCol,LRRow,ss[BRCorner]);

  // Then, fill in the lines between the corners
  for (col = ULCol + 1; col < LRCol; col++) {
    PutChar(col,ULRow,ss[THorizontal]);
    PutChar(col,LRRow,ss[BHorizontal]);
  }

  for (row = ULRow + 1; row < LRRow; row++) {
    PutChar(ULCol,row,ss[VerticalLine]);
    PutChar(LRCol,row,ss[VerticalLine]);
  }

  // Then draw the Vertical lines
  ++NVertical;
  ++NHorizontal;
  if (NVertical > 0) {
    verticalOffset = (LRCol - ULCol) / NVertical;
    col = ULCol;
    for (i = 0; i < NVertical-1; i++) {
      col += verticalOffset;
      PutChar(col,ULRow,ss[TDeadEnd]);
      PutChar(col,LRRow,ss[BDeadEnd]);
      for (row = ULRow + 1; row < LRRow; row++)
        PutChar(col,row,ss[VerticalLine]);
    }
  }
  // Then draw the Horizontal lines
  if (NHorizontal > 0) {
    horizontalOffset = (LRRow - ULRow) / NHorizontal;
    row = ULRow;
    for (i = 0; i < NHorizontal-1; i++) {
      row += horizontalOffset;
      PutChar(ULCol,row,ss[LDeadEnd]);
      PutChar(LRCol,row,ss[RDeadEnd]);
      for (col = ULCol + 1; col < LRCol; col++)
        PutChar(col,row,ss[THorizontal]);
    }
  }
  // Finally, locate & fill in the internal intersections
  if ((NVertical > 0) && (NHorizontal > 0)) {
    col = ULCol;
    for (i = 0; i < NVertical-1; i++) {
      col += verticalOffset;
      row = ULRow;
      for (j = 0; j < NHorizontal-1; j++) {
        row += horizontalOffset;
        PutChar(col,row,ss[Cross]);
      }
    }
  }
}
