/* filename: TIME.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <timedate.h>
  
char * Time(double x, TimeUnits units)
{
  long TotalSeconds;
  static char _tzfar buf[20] = "";
  
  TimeError = 0;
  if (x < 0) {
    TimeError = NegativeTime;
    return "  :  :  ";
  }
  switch (units) {
    case Hours:   x *= 3600.0; break;
    case Minutes: x *= 60.0;   break;
    case Seconds: break;
    case Ticks:   x /= TicksPerSecond; break; // 1193180 / 65536
  }
  TotalSeconds = ( ((x-(long)x)>0.5F)?(long)(x+1.0F):(long)x ); // round
  hour = (int)(TotalSeconds / 3600);
  TotalSeconds %= 3600;
  minute = (int)(TotalSeconds / 60);
  second = (int)(TotalSeconds - 60 * minute);
  sprintf( buf,"%02d:%02d:%02d", hour, minute, second );
  
  return buf;
}
