/* filename: SELECTDT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <vidpop.h>
#include <sayget.h>
#include <timedate.h>
#ifdef _MSC_VER
#include <graph.h>
#endif

#define NORMAL  TRUE
#define REVERSE FALSE

extern unsigned char FColor, BColor;
static int SelectedDay=0;
static char _tzfar d[20] = "";

static char * DateFromScreenPos(unsigned int screenpos)
{
  char *tmp = "  ", *p;

  p = (char *)MK_FP(VideoSegment(),screenpos);
  *tmp = *p;
  tmp[1] = *(p + 2);
  SelectedDay = atoi(tmp);

  return DateFrom(Year(d),Month(d),SelectedDay); // return some selected date
}

static void paintIt(int fl)
{
  unsigned char fgd, bgd, attr;
  char date[11];

  fgd = fl ? FColor : CalendarHighlightFG;
  bgd = fl ? BColor : CalendarHighLightBG;
  if (UsersAttrProc) {
    strcpy(date,DateFromScreenPos(ScreenPos));
    attr = UsersAttrProc(date);
    if (attr && (fl ? 1 : SelectedColor)) {
      fgd = attr & 0x0F;
      bgd = attr >> 4;
    }
  }
  Paint((ScreenPos % 160) / 2+1, ScreenPos / 160+1, 2, fgd, bgd);
}

static void AddExtraButtons(unsigned char x, unsigned char y)
{
  if (MouseDriverPresent) {
    At(x + 1,y,"[-y]");
    At(x + 28,y,"[-m]");
    At(x + 1,y + 10,"[+y]");
    At(x + 28,y + 10,"[+m]");
    AddTarget(x + 2,y,x + 3,y, -1,LeftButtonReleased);
    AddTarget(x + 29,y,x + 30,y, -2,LeftButtonReleased);
    AddTarget(x + 2,y + 10,x + 3,y + 10, -3,LeftButtonReleased);
    AddTarget(x + 29,y + 10,x + 30,y + 10, -4,LeftButtonReleased);
    AddTarget(x,y,x + 32,y + 10, 0,RightButtonReleased);
  }
}

static void showData(void)
{
  DisableMouse();
  DisplayCalendarData(d,FALSE);
  AddExtraButtons((unsigned char)OrigX,(unsigned char)OrigY);
  EnableMouse();
}

static int shiftPos(int offset)
{
  unsigned char * ptr;

  ptr = (unsigned char *)MK_FP(VideoSegment(), ScreenPos + offset);
  if (((*ptr == ' ') || isdigit(*ptr)) && isdigit(*(ptr+2))) {
    paintIt(NORMAL);
    ScreenPos += offset;
    paintIt(REVERSE);
    return TRUE;
  }
  else
    return FALSE;
}

static void showIt(int saveday)
{
  register int x;

  if (FreezeDay) {
    x = (Day(d) < 15)  ? 1 : -1;
    while (DOW(d) != saveday)
      strcpy(d, DatePlus(d,x));
  }
  showData();
}

static void goYear(int off)
{
  register int x, y;

  if (!FreezeYear) {
    x = Year(d) + off;
    y = Month(d);
    //  make sure that we end up on a legal day of the month
    while (SelectedDay > DaysInMonth(DateFrom(x, y, 1)))
      --SelectedDay;
    strcpy(d, DateFrom(x, y, SelectedDay));
    showIt(DOW(d)); //  make sure that we end up on proper DOW
  }
}

char * SelectDate(const char * indate)
{
  int      oldorder, saveCenturyOn, oldDateFormat, saveX, saveY;
  char     key, *ptr;
  EventRec e;
  int      saveday, ifMouse, saveAMP, fl;
  static char _tzfar result[11] = "";
  char     HighlightDate[11], tmp[3] = "  ";
  ActivityType saveActivity;
  unsigned cursorvar, VideoSeg;
  char letters[5];
#ifdef _MSC_VER
  short r1,r2,c1,c2;

  _gettextwindow(&r1, &c1, &r2, &c2);
  saveX = wherex();
  saveY = wherey();
  _settextwindow(1,1,25,80);
#else
  struct text_info ti;
  gettextinfo(&ti);
  saveX = wherex();
  saveY = wherey();
  window(1,1,80,25);
#endif

  if (!CheckRegisteredUnits("SelectDate", REGTZCOMMON+REGTZVIDPOP+REGTZSAYGET+REGTZTMDATE))
    return "";

  VideoSeg = VideoSegment();
  saveAMP = AutoMousePlacement;
  AutoMousePlacement  = FALSE;
  oldorder = dBASEOrder;
  dBASEOrder = FALSE;
  SaveCursor(&cursorvar);
  SetCursorOff();
  oldDateFormat = DateFormat;
  if (DateFormat == Ansi)
#ifdef GERMAN
    DateFormat = German;
#else
    DateFormat = American;
#endif

  strcpy(d, indate);
  ParseClauses(d);
  saveCenturyOn = CenturyOn;
  if (!CenturyOn) {
    Convert2American(d);
    d[5] = '\0';
    sprintf(&d[5],"/%s%02d",DefaultCentury(&d[6]),atoi(&d[6])); // add the century
    CenturyOn = TRUE;
    ConvertFromAmerican(d);
  }
  if (PopDown) {
    fl = CalendarLineStyle & 0x80; // a shadowed box
    PushWindow((char)OrigX,(char)OrigY,(char)(OrigX + 32 + (fl ? 2 : 0)),
      (char)(OrigY + 10 + (fl ? 1 : 0)));
  }
  Box(OrigX,OrigY,OrigX + 32,OrigY + 10,(char)CalendarLineStyle,CalendarHeading);
  AddExtraButtons((unsigned char)OrigX,(unsigned char)OrigY);
  PaintDaysOfWeekLetters();
  DisplayCalendarData(d,FALSE); // adds targets, too
  switch(Country) {
    case USA:
    case Britain: ptr = "mhyr"; break;
    case Italy:   ptr = "abcd"; break;
    case France:
    case Quebec:  ptr = "msae"; break;
    case Germany: ptr = "mtjr"; break;
    case Spain:   ptr = "abcd"; break;
    case Russia:  ptr = "棤"; break;
  }
  strcpy(letters, ptr);
  // now let user select a date from the calendar
  EnableMouse();
  do {
    ifMouse = 0;
    ptr = (char *)MK_FP(VideoSeg,ScreenPos);
    tmp[0] = *ptr;
    tmp[1] = *(ptr+2);
    SelectedDay = IntegerVal(tmp);
    strcpy(HighlightDate, DateFrom(Year(d),  Month(d), SelectedDay));
    PaintFullDate(HighlightDate,FALSE);
    PaintDayOfYear(HighlightDate);
    // wait for a keystroke
    saveActivity = Activity;
    Activity = _Calendar;
    // Key := ReadKey; old, mouseless way
    GetEvent(&e); // new way..sees keypresses and mouse clicks
    Activity = saveActivity;
    key = '\xFF'; // think of this as NOP
    switch (e.WhichEvent) {
      case Mouse:
        if (e.v.sMouse.ButtonMask == LeftButtonReleased) {
          switch (e.v.sMouse.TargetID) {
            case -1:
              key = 'G'; // home
              break;
            case -2:
              key = 'I'; // page up
              break;
            case -3:
              key = 'O'; // end
              break;
            case -4:
              key = 'Q'; // page down
              break;
          }
          if (e.v.sMouse.TargetID > 0) {
            SelectedDay = e.v.sMouse.TargetID;
            key = '\r'; // Enter key on a date
            ifMouse = 1;
          }
        }
        else {
          if ((e.v.sMouse.ButtonMask == RightButtonReleased)
            && (e.v.sMouse.TargetID == 0))
            key = '\x1B';
          else { // mouse motion only
            if (SelectedDay != e.v.sMouse.TargetID) {
              if (SelectedDay == (e.v.sMouse.TargetID+1))
                key = 'K'; // left arrow
              if (SelectedDay == (e.v.sMouse.TargetID-1))
                key = 'M'; // right arrow
              if (SelectedDay == e.v.sMouse.TargetID + 7)
                key = 'H'; // up arrow
              if (SelectedDay == e.v.sMouse.TargetID - 7)
                key = 'P'; // down arrow
            }
          }
        }
        break;
      case Keyboard:
        key = e.v.sKeyboard.Key;
        if (e.v.sKeyboard.Key == '\0')
          key = e.v.sKeyboard.ScanCode;
        else
          key = Lowcase(key);
        break;
    }
    if (key == '+')
      key = 'M'; // the same as righ arrow
    if (key == '-')
      key = 'K'; // the same as left arrow
    switch (key) {
      case 'H':
        if (!FreezeWeek) // up arrow
			// look up and see if there is a date there
          shiftPos(-160);
        break;
      case 'P':
        if (!FreezeWeek) // Down Arrow
                         // look down and see if there is a date there
                         // make sure we don't look beyond last possible row
          if ((ScreenPos/160 + 1) < (unsigned)(OrigY + 8))
            shiftPos(160);
        break;
      case 'M':
        if (!FreezeDay) //  right arrow
                        // look right and see if there is a date there
          if (!shiftPos(8)) // look at the beginning of next row
            if (!FreezeWeek) // make sure we don't look outside the calendar box
              shiftPos(112);
        break;
      case 'K':
        if (!FreezeDay) // Left Arrow
                        // look left and see if there is a date there
          if (!shiftPos(-8)) // look at the right hand end of the row above
            if (!FreezeWeek)
              shiftPos(-112);
        break;
      case 'Q': // Or ((cyear(d) = '99') and (Month(d) = 12))
        if (!FreezeMonth) { // PgDn = advance a month
          if (FreezeDay) // make sure that we end up on proper DOW
            saveday = DOW(d);
          if (!((Month(d) == 12) && FreezeYear)) {
            if (Month(d) == 12)
              strcpy(d, DateFrom(Year(d) + 1,1,SelectedDay));
            else { // make sure that we end up on a legal day of the month
              while (SelectedDay > DaysInMonth(DateFrom(Year(d),Month(d) + 1,1)))
                --SelectedDay;
              strcpy(d, DateFrom(Year(d),Month(d) + 1,SelectedDay));
            }
            showIt(saveday);
          }
        }
        break;
      case 'I': // and (not ((cyear(d) = '00') and (Month(d) = 1)))
        if (!FreezeMonth) { // PgUp = backup a month
          if (FreezeDay)  // make sure that we end up on proper DOW
            saveday = DOW(d);
          if (!((Month(d) == 1) && FreezeYear)) {
            if (Month(d) == 1)
              strcpy(d, DateFrom(Year(d) - 1,12,SelectedDay));
            else { // make sure that we end up on a legal day of the month
              while (SelectedDay > DaysInMonth(DateFrom(Year(d),Month(d) - 1,1)))
                --SelectedDay;
              strcpy(d, DateFrom(Year(d),Month(d) - 1,SelectedDay));
            }
            showIt(saveday);
          }
        }
        break;
      case 'G': // Or (cyear(d) = '01'), home key = back a year
        goYear(-1);
        break;
      case 'O': // Or (cyear(d) = '99'), end key = advance a year
        goYear(1);
        break;
    } // case
    // Now dealing w/Extra letters
    if (key == letters[0]) { // go to start of month
      if (!FreezeMonth) {
        if (Day(d) == 1)
          strcpy(d, DatePlus(d, -1));
        strcpy(d, DatePlus(d, -Day(d)+1));
        showData();
      }
    }
    else
      if (key == letters[1]) { // go to end of month
        if (!FreezeMonth) {
          if (Day(DatePlus(d,1)) == 1)
            strcpy(d, DatePlus(d, 1));
          strcpy(d, DatePlus(d, -Day(d)+DaysInMonth(d)));
          showData();
        }
      }
      else
        if (key == letters[2]) { // go to start of year
          if (!FreezeYear) {
            if (DayOfYear(d) == 1)
              strcpy(d, DatePlus(d, -1));
            strcpy(d, DatePlus(d, -DayOfYear(d)+1));
            showData();
          }
        }
        else
          if (key == letters[3]) { // go to end of year
            if (!FreezeYear) {
              if (DayOfYear(DatePlus(d, 1)) == 1)
                strcpy(d, DatePlus(d, 1));
              strcpy(d, DatePlus(d, -DayOfYear(d)+DaysInYear(d)));
              showData();
            }
          }
  }  while ((key != '\r') && (key != EscapeCh));
  DisableMouse();
  if (key == EscapeCh) // return an empty string
    *result = 0;
  else
    strcpy(result, ifMouse ? DateFrom(Year(d), Month(d),SelectedDay) :
      DateFromScreenPos(ScreenPos));
  dBASEOrder = oldorder;
  DateFormat = oldDateFormat;
  if (!saveCenturyOn) { // strip off the century
    if (result[0]) {
      Convert2American(result);
      result[6] = result[8];
      result[7] = result[9];
      result[8] = '\0';
    }
    CenturyOn = FALSE;
  }
  if (result[0])
    ConvertFromAmerican(result);
  if (PopDown)
    PopWindow(); // restore the old window
#ifdef _MSC_VER
  _settextwindow(r1, c1, r2, c2);
#else
  window( ti.winleft, ti.wintop, ti.winright, ti.winbottom);
#endif
  gotoxy(saveX,saveY);
  saveX = CursorOn; // Don't change CursorOn
  RestoreCursor(cursorvar);
  CursorOn = saveX;
  AutoMousePlacement = saveAMP;
  return result;
}

#endif
