/* filename: PARSTIME.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <common.h>
#include <sayget.h>

int hour=0, minute=0, second=0;
int TimeError = 0;

void ParseTime(char * t)
{
  int colon1, colon2;

  TimeError = 0; // innocent until proven guilty

  // parse the hours:
  colon1 = PosOf(1, ":", t);
  colon2 = PosOf(2, ":", t);  // find the next colon
  if ((colon1 < 0) || (colon2 < 0)) {
    TimeError = NoColon;
    return;
  }
  hour = atoi( t );
  if ((hour < 0) || (hour > 99)) {
    TimeError = InvalidTime;
    return;
  }
  // parse the minutes:
  minute = atoi( &t[colon1+1] );
  if (minute < 0) {
    TimeError = InvalidTime;
    return;
  }
  // parse the seconds:
  second = atoi(&t[colon2+1]);
  if (second < 0) {
    TimeError = InvalidTime;
    return;
  }
  if (second > 59) {
    ++minute;
    second -= 60;
  }
  if (minute > 59) {
    ++hour;
    minute -= 60;
  }
  if ((hour > 99) || (minute > 59) || (second > 59)) {
    TimeError = InvalidTime;
    return;
  }
  // pass the cleaned up string back
  sprintf(t,"%02d:%02d:%02d",hour,minute,second);
}
