/* filename: DISPCALD.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>

// set default calendar colors
unsigned char CalendarHighlightFG  = BLACK;
unsigned char CalendarHighLightBG  = LIGHTGRAY;
int           CalendarLineStyle  = SingleLine;
char _tzfar   CalendarHeading[31]  = "";
unsigned      ScreenPos = 0;

void DisplayCalendarData(char * d, int plain)
{
  char    FirstDate[11], LastDate[11];
  int     ThisDay, LastDay, Today, x, y;
  char    TempD[11];
  unsigned char   AttrByte;

  // x and y are local since they will be modified here
  x = OrigX;
  y = OrigY;

  // construct the date string for display at top of calendar
  if (!*d)
    strcpy(d, SystemDate());
  PaintFullDate(d, plain);

  // calculate the limits of this month
  LastDay = DaysInMonth(d);
  strcpy(FirstDate, DateFrom(Year(d),Month(d),1));
  strcpy(LastDate, DateFrom(Year(d),Month(d),LastDay));
  Today = Day(d);
  x += 3;
  y += 3;

  // write at all 42 possible date positions
  for (ThisDay = 1 - DOW(FirstDate) + 1; ThisDay <= 42 - DOW(FirstDate) + 1; ThisDay++)
  {
    if ((ThisDay > 0) && (ThisDay < LastDay + 1)) {
      At(x,y,SInteger(ThisDay,2));
      AddTarget(x,y,x + 1,y,ThisDay,LeftButtonReleased);
      if (UsersAttrProc) {
        strcpy(TempD, DatePlus(FirstDate,ThisDay - 1));
        AttrByte = UsersAttrProc(TempD);
        if (AttrByte)
          Paint(x,y,2,(unsigned char)(AttrByte & 0x0F),(unsigned char)(AttrByte >> 4));
      }
    }
    else
      At(x,y,"  "); // erase possible numbers from prior displayed month
    if ((!plain) && (ThisDay == Today)) {
      Paint(x,y,2,CalendarHighlightFG,CalendarHighLightBG);
      // calculate the starting screen position of highlight
      ScreenPos = ((y-1) * 160) + (x-1) * 2;
    }
    x += 4;
    if (x > OrigX + 27) { // right hand edge of calendar
      x = OrigX + 3; // set x to left edge of calendar
      ++y; // advance to next row
    }
  }
  if (!plain)
    PaintDayOfYear(d);
}
#endif
