/* filename: DATEPLUS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>

char * DatePlus(const char * datestring, int n) //  returns a date
{
  static char _tzfar date[30] = "";
  int localCenturyOn, this_century;
  Datetype newdate;
  char   buf[50];
  size_t len = strlen(datestring);

  strcpy(date, datestring); // make a copy not to spoil the given string
  DBFError = 0;
  ZeroPad(date);
  if (!n)
    return date;
  if (!ValidDate(date)) {
    sprintf(buf, "[DatePlus(%s,%d)]", date, n);
    SetError(220,1,buf);
    return date;
  }
  Convert2American(date);
  localCenturyOn = len == 10;
  newdate.Mo = atoi(&date[0]);
  newdate.Dy = atoi(&date[3]);
  newdate.Yr = atoi(&date[6]);
  this_century = ThisCentury(&date[6]);
  if (!localCenturyOn)
    newdate.Yr += this_century;
  DateTypeFromJulian(JulianFromDateType(&newdate) + n, &newdate);
  if (!localCenturyOn)
    newdate.Yr = (newdate.Yr-this_century)%100;
  sprintf(date, localCenturyOn ? "%02d/%02d/%04d" : "%02d/%02d/%02d",
        newdate.Mo,newdate.Dy,newdate.Yr);
  ConvertFromAmerican(date);

  return date;
}
