/* filename: SPOOLER.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef _MSC_VER
 #include <graph.h>
#else
 #include <alloc.h>
#endif

#include <spooler.h>

#ifdef _MSC_VER
 #pragma optimize("i", on)
 #pragma optimize("e", off)
 #pragma check_stack(off)
 #pragma check_pointer(off)

static void _delay(unsigned int wait)
{
  long goal;

  goal = *BiosTimerTicks;
  goal += (long)(wait / 55);

  while(goal > *BiosTimerTicks);
}

 #define setvect  _dos_setvect
 #define getvect  _dos_getvect
 #define clrscr() _clearscreen(_GWINDOW)
#else
 #pragma option -N- -k+
#endif

extern unsigned char (*PrinterStatus)(void);
extern int (_far * UserPrinterCheck)(void); // used by PrinterReady to check printer status

typedef void (interrupt _far *ISR)();
typedef int BIOSPortTable[MaxPorts];

int           ComBase = 0; // base for current open port
unsigned int  StatusPort = 0;
unsigned char PortNumber = 0;
int           SpoolerInstalled = 0;
int           Parallel = 0;
unsigned char SpoolError = 0;

static char          DefaultPrinter[21] = "";
static unsigned char TimerHandle = 0;
static ISR           OldPrinterInterrupt, OldTimerInterrupt, OriginalVector;
static unsigned int  DataPort, CommandPort;
static char          ComBuffer[ComBufferSize+1];
static int           SpoolerBusy = FALSE;
static int           InitFlag = FALSE;
static int ComPortOpen  = FALSE;

static int ComPort;          //  current Open port number (1 or 2)
static int ComIrq;           //  irq for current open port
static int ComBufferOverflow;//  True if buffer overflow has happened
static int ComBufferUsed;
static int ComMaxBufferUsed; //  ComBuffer is empty if Head = Tail
static int ComBufferHead;    //  Location in ComBuffer to put next char
static int ComBufferTail;    //  Location in ComBuffer to get next char
static int ComBufferMax;

static BIOSPortTable far *PortTable = MK_FP(0x40,0x0);
// This table is initialized by BIOS equipment determination
// code at boot time to contain the base addresses for the
// installed communication adapters.  A value of 0 means "not installed.

static struct BaudTable {
  int Baud;
  int Bits;
} BaudTable[MaxBaud] = {
  {110,0x00},{150,0x20},{300,0x40},{600,0x60},
  {1200,0x80},{2400,0xA0},{4800,0xC0},{9600,0xE0}
};

static void InitializeComPort(int ComPort, int ComParm)
// Issue Interrupt 0x14 to initialize the UART
{
  struct REGPACK r;

  memset(&r, 0, sizeof(r));
  r.r_ax = ComParm & 0x00FF; // AH=0; AL=ComParm
  r.r_dx = ComPort;
  intr(0x14, &r);
}

static void interrupt _far ComISR()
{
  // Interrupt Service Routine. Invoked when the UART has received a byte of
  //   data from the communication line
  _asm {
    sti
    mov dx, ComBase
    in  al, dx
    mov bx, ComBufferHead
    mov byte ptr ComBuffer[bx], al
    inc bx
    cmp bx, ComBufferMax
    jle L001
    xor bx, bx
  }
L001:
  _asm {
    cmp bx, ComBufferTail
    jne L002
    mov ComBufferOverflow, 1
    nop
    jmp short L003
  }
L002:
  _asm {
    mov ComBufferHead, bx
    inc ComBufferUsed
    mov bx, ComBufferUsed
    cmp bx, ComMaxBufferUsed
    jle L003
    mov ComMaxBufferUsed, bx
  }
L003:
  _asm {
    cli
    mov al, 20h
    out 20h, al
  }
}

static void CloseComPort(void)
//  reset the interrupt system when UART interrupts no longer needed
{
  int i, m;

  if(ComPortOpen) { //  disable the IRQ on the 8259
    _disable();
    i = inp(I8088_IMR); //  get the interrupt mask register
    m = 1 << ComIrq;    //  set mask to turn off interrupt
    outp(I8088_IMR, i | m);
    outp(UART_IER + ComBase, 0);//  disable the 8250 data ready interrupt
    outp(UART_MCR + ComBase, 0);//  disable OUT2 on the 8250
    setvect(ComIrq + 8, OriginalVector);
    _enable();
    ComPortOpen = FALSE;
  }
}

static int OpenComPort(int OurPort, int BaudRate, char Parity, int WordSize, int StopBits)
{
  #define Com1 0
  #define Com2 1

  int ComParm;
  int i, m;

  if(ComPortOpen) CloseComPort();
  ComPort = 0;
  if((OurPort == (Com2)) && (*PortTable)[1])
    ComPort = 2;
  else
    if((*PortTable)[0])
      ComPort = 1; // default to COM1
  if(ComPort == 0) return FALSE;
  ComBase = (*PortTable)[ComPort-1];
  ComIrq = (ComBase >> 8) + 1; // IRQ assigned here, only works for COM1 and COM2
  if(inp(UART_IIR + ComBase) & 0x00F8)
    return FALSE;
  else {
    ComBufferUsed     = 0;
    ComMaxBufferUsed  = 0;
    ComBufferHead     = 0;
    ComBufferTail     = 0;
    ComBufferOverflow = FALSE;
    ComBufferMax      = ComBufferSize;
    ComParm           = 0x0000;//  Build the ComParm for RS232_Init
    //  Set up the bits for the baud rate
    i = 0;
    do {
      i++;
    } while (!((BaudTable[i-1].Baud == BaudRate) || (i == MaxBaud)));
    ComParm |= BaudTable[i-1].Bits;
    if(toupper(Parity) == 'E')
      ComParm |= 0x0018;
    else
      if(toupper(Parity) == 'O')
        ComParm |= 0x08;  //  default to No parity
    ComParm |= ((WordSize == 7) ? 0x02 : 0x03); // default to 8 data bits
    if(StopBits == 2)
      ComParm |= 0x04; //  default to 1 stop bit
    InitializeComPort(ComPort - 1, ComParm);
    OriginalVector = getvect(ComIrq + 8);
    setvect(ComIrq + 8, ComISR);
    //  read the RBR and reset any possible pending error conditions
    //  first turn off the Divisor Access Latch Bit to allow access to RBR, etc.
    _disable();
    outp(UART_LCR + ComBase, inp(UART_LCR + ComBase) & 0x7F);
    //  read the Line Status Register to reset any errors it indicates
    i = inp(UART_LSR + ComBase);
    //  read the Receiver Buffer Register in case it contains a character
    i = inp(UART_RBR + ComBase);
    //  enable the irq on the 8259 controller
    i = inp(I8088_IMR);   //  get the interrupt mask register
    m = (1 << ComIrq) ^ 0x00FF;
    outp(I8088_IMR, i & m);
    //  enable the data ready interrupt on the 8250
    outp(UART_IER + ComBase, 0x01);  //  enable data ready interrupt
    //  enable OUT2 on 8250
    i = inp(UART_MCR + ComBase);
    outp(UART_MCR + ComBase, i | 0x08);
    _enable();
    ComPortOpen = TRUE;
    return TRUE;
  }
}

void SpoolArray(void *buffer, unsigned int Size)
// alternate fast way of appending to the spooler
{
  int SaveEnable;

  SaveEnable = SpoolRec.Enabled;
  SpoolRec.Enabled = FALSE;
  if(Size <= SpoolerBufSize - SpoolRec.Tail + 1) {
    memmove(&SpoolRec.buffer[SpoolRec.Tail-1], buffer, Size);
    SpoolRec.Tail += Size;
  }
  SpoolRec.Enabled = SaveEnable;
}

#ifdef _MSC_VER
static void interrupt New17(unsigned ES, unsigned DS, unsigned DI,
                            unsigned SI, unsigned BP, unsigned SP,
                            unsigned BX, unsigned DX, unsigned CX,
                            unsigned AX)
#else
#pragma argsused
static void interrupt New17(unsigned BP, unsigned DI, unsigned SI,
                            unsigned DS, unsigned ES, unsigned DX,
                            unsigned CX, unsigned BX, unsigned AX)
#endif
{
  // AH is modified, all others should be unchanged
  // AH is returned = 1 if character cannot be printed with other bits set
  // as if status was requested
  _enable();
  switch(AX >> 8) {
    case 0:  // AH = 0 means this is a character to be printed.
      //  AL = character
      SpoolRec.Enabled = FALSE;   //  disable the spooler for test
      if(SpoolRec.Tail > SpoolerBufSize) { // buffer is full
        // give the spooler a chance to send some chars to the printer
        SpoolRec.Enabled = TRUE;
#ifdef _MSC_VER
        _delay(110);
#else
        delay(110); // two timer ticks
#endif
        SpoolRec.Enabled = FALSE;
      }
      if(SpoolRec.Tail <= SpoolerBufSize) {
        SpoolRec.buffer[SpoolRec.Tail-1] = (char) (AX & 0xff);
        SpoolRec.Tail++;
        AX = (0x90 << 8) + (AX & 0xff); //  printer selected and not busy
        SpoolError = 0;                 //  Buffer did not overflow
      } else {                            //  do nothing, spooler will be overflowed
        AX = (0x09 << 8) + (AX & 0xff); //  printer timed out and I/O error occured
        SpoolError = 254;               //  Buffer overflowed
      }
      SpoolRec.Enabled = TRUE;
      break;

    case 1 :  // User wants to initialize printer. Do nothing
      break;

    case 2 :  // User wants to get the printer status. Return the status,
      // not busy if the buffer is not full, busy otherwise
      AX = (SpoolRec.Tail >= SpoolerBufSize) ? 0x1800 : 0x9000;  // printer busy or OK
      break;
  }
}

static void interrupt _far Spool()
{
  int i;

  if(!SpoolerBusy) {
    SpoolerBusy = TRUE;
    if(SpoolerInstalled && ((SpoolRec.Enabled) && (SpoolRec.Tail > 1))) {
      i = 0;
      if(Parallel) {
        // PrinterNotBusy and Selected
        while((((inp(StatusPort) & 0xf8) ^ 0x48) == 0x90) &&
              (i < (int)SpoolerPacketSize) &&
              ((unsigned int) i < SpoolRec.Tail - 1)) {
          outp(DataPort, SpoolRec.buffer[i]);
          outp(CommandPort, 0x0d);  // shake the strobe line
          outp(CommandPort, 0x0c);
          i++;
#ifdef _MSC_VER
          _delay(1);
#else
          delay(1); // unfortunately, this is a must, or the Printer looks busy on the next pass
#endif
        }
      } else { // output to the serial port
        outp(UART_MCR + ComBase, 0x0B); //  turn on OUT2, DTR, and RTS
        while(((inp(UART_MSR + ComBase) & 0x10) == 0x10) &&
              ((inp(UART_LSR + ComBase) & 0x20) == 0x20) &&
              (i < (int)SpoolerPacketSize) &&
              ((unsigned int)i < SpoolRec.Tail - 1)) {
          i++;
          _disable();
          outp(UART_THR + ComBase, SpoolRec.buffer[i]);
          _enable();
#ifdef _MSC_VER
          _delay(DelayTime);
#else
          delay(DelayTime); // this is dependent on baud
          // rate...needs to be 1 chars time
#endif
        }
      }
      if(i > 0) {
        memmove(&SpoolRec.buffer[0], &SpoolRec.buffer[i], SpoolerBufSize - i);
        SpoolRec.Tail -= i;
      }
    }
    SpoolerBusy = FALSE;
    //  chain to the regular timer tick interrupt
    OldTimerInterrupt = ChainISRAddress(TimerHandle);
    _chain_intr(OldTimerInterrupt);
  }
}

static void RestoreOldInterruptVectors(void)
{
  _disable();
  setvect(PrinterInterrupt, OldPrinterInterrupt);
  _enable();
  CloseComPort();
  SpoolerInstalled = FALSE;
}

static void SetUpNewInterruptVectors(void)
{
  _disable();
  OldPrinterInterrupt = getvect(PrinterInterrupt);
  setvect(PrinterInterrupt, New17);
  _enable();
  SpoolerInstalled = TRUE;
}

void CancelSpooling(void)
{
  SpoolRec.Tail = 1;
}

static void DeallocateBuffer(void)
{
  CancelSpooling();
  if(SpoolRec.buffer && SpoolerBufSize) { // free previous heap allocation
    free(SpoolRec.buffer);
    SpoolRec.buffer = NULL;
  }
}

static void AllocateBuffer(unsigned int newbufsize)
{
  if(SpoolRec.buffer == NULL) {
    CancelSpooling();
    // added check to see that new buffer size is not larger than
    // maximum buffer - rsm 5-20-89
    if((coreleft() > (unsigned long)newbufsize) &&
       (newbufsize < MaxBufferSize + 1)) {
      SpoolerBufSize = newbufsize;
      if((coreleft() > (unsigned long) SpoolerBufSize))
        // allocate new space on the heap for new buffer
        SpoolRec.buffer = (char *) malloc(SpoolerBufSize);
      else {
        SpoolRec.buffer = NULL;
        SpoolError = 253; //  insufficient memory
      }
    } else   // not enough contiguous memory is available. Set the error
      // flag, and do nothing else
      SpoolError = 253;
  }
}

void SetPrinterTo(char *Mode)
{
  int i, ibaud, iWordLength, iStopBits, mlen;
  char temp[10];

  DelayTime = 10;
  mlen = strlen(Mode);
  strupr(Mode);   // uppercase the string
  for(i = 0; i < mlen; i++)  // and remove spaces
    if(Mode[i] == ' ')
      strcpy(Mode + i, Mode + i + 1);
  if(!mlen) {
    if (SpoolerInstalled) {
      RestoreOldInterruptVectors();
      DeallocateBuffer();
    }
    return;
  }
  CancelSpooling();
  SpoolError = 0;
  PortNumber = 0; // default to device 1
  strncpy(temp, Mode, 3);
  temp[3] = 0;
  if(!strcmp(temp, "LPT")) {
    if(mlen < 4)
      SpoolError = 244; // LPT number not given
    else {
      PortNumber = Mode[3] - '1';
      if(PortNumber > 2)
        SpoolError = 245; // LPT number out of range
      else {
        DataPort = *(unsigned int far *) MK_FP(0x0040,0x0008 + (PortNumber << 1));
        StatusPort = DataPort + 1;
        CommandPort = DataPort + 2;
        if(DataPort == 0)
          SpoolError = 246; // no physical device exists
        else {
          CloseComPort();   // parallel port is ready to go
          Parallel = TRUE;
          outp(CommandPort, 0x0c);    // initialize the PARALLEL printer
          DelayTime = 1;
        }
      }
    }
  } else {
    if(!strcmp(temp, "COM")) {
      if(mlen < 11) // Not enough parameters given
        SpoolError = 247;
      else {
        PortNumber = Mode[3] - '1';
        if(PortNumber > 1) // Device number out of range
          SpoolError = 245;
        else {
          strcpy(Mode, Mode + 5);
          i = (int)(strchr(Mode, ',') - Mode);
          strncpy(BaudRate, Mode, i);
          BaudRate[i] = 0;
          if(!strstr("110 150 300 600 1200 2400 4800 9600", BaudRate))
            SpoolError = 248;// invalid baudrate
          else {
            ibaud = atoi(BaudRate);
            // BaudRate is ok, compute the DelayTime:
            DelayTime = (unsigned char) ((10000 / ibaud) + 1);
            strcpy(Mode, Mode + strlen(BaudRate) + 1);
            Parity = Mode[0];
            if(strchr("OEN", Parity) == NULL) // invalid Parity
              SpoolError = 249;
            else {
              WordLength = Mode[2];
              if(!strchr("78", WordLength)) // invalid wordlength
                SpoolError = 250;
              else {
                iWordLength = WordLength - '0';
                StopBits = Mode[4];
                if(!strchr("12", StopBits)) // invalid stop bits
                  SpoolError = 251;
                else { // USE Comm TO OPEN COM PORT, ETC
                  iStopBits = StopBits - '0';
                  if(!OpenComPort(PortNumber, ibaud, Parity, iWordLength, iStopBits))
                    SpoolError = 252;
                  else
                    Parallel = FALSE;   // the serial port is ready to go
                }
              }
            }
          }
        }
      }
    } else SpoolError = 247;   // invalid mode command
  }
  if(!SpoolError) {
    if(!SpoolerInstalled) {
      SetUpNewInterruptVectors();
      AllocateBuffer(SpoolerBufSize);
    }
    strcpy(DefaultPrinter, temp);
  }
}

static void interrupt _far Empty23() {}

static void SpoolerExitProc(void)
{
  ISR  Old23;

  if(SpoolerInstalled) {   //  if printer interrupt is ours
    if(CharsInSpooler() > 0)  {
      _disable();
      Old23 = getvect(0x23);
      setvect(0x23, Empty23);
      _enable();
      clrscr();
      printf("%s\n", printer_spool_buffer_still_contains_characters_please_wait);
      printf("%s\n", press_esc_to_cancel_printing);
      printf("\n");
      while(kbhit())
        getch();   // clear the keyboard buffer first
      do {
        if(kbhit()) {
          if(getch() == 0x1B)
            CancelSpooling();   // if ESC, then wait no more
        }
        cprintf("%s%6d\r", characters_left_to_print, CharsInSpooler());
#ifdef _MSC_VER
        _delay(DelayTime);
#else
        delay(DelayTime);
#endif
      } while(CharsInSpooler() != 0);
      printf("%s%6d\r", characters_left_to_print, CharsInSpooler());
      _disable();
      setvect(0x23, Old23);
      _enable();
    }
    RestoreOldInterruptVectors();
  }
  _disable();
  RemoveISRVector(TimerHandle);
  _enable();
}

static void SpoolerInit(void)
{
  PrinterStatus     = RealPrinterStatus;
  SpoolRec.Enabled  = FALSE;
  SpoolRec.buffer   = NULL;
  SpoolerPacketSize = 32;
  SpoolerInstalled  = FALSE;

  AllocateBuffer(DefaultBufferSize);
  if(!SpoolRec.buffer)
    return;
  TimerHandle = AddISRVector(Spool);
  SetPrinterTo("LPT1:");   // default to LPT1
  // this will also set up the interrupts
  if(!SpoolError)
    StartSpooling();
  atexit(SpoolerExitProc);
}

void SetSpoolerOn(void)
{
  if (!InitFlag) {
    SpoolerInit();
    InitFlag++;
  }
  SetPrinterTo(DefaultPrinter);
}

void SetSpoolerOff(void)
{
  SetPrinterTo("");
}

int SpoolerReady(void)
//  returns true if there is room for a full size string to be printed
{
  return (SpoolerInstalled && (SpoolRec.Tail < (SpoolerBufSize - (STRSIZ-1))));
}

void SetPacketSizeTo(unsigned char Size)
{
  CancelSpooling();
  if(Size < 1)
    Size = 1;
  SpoolerPacketSize = Size;
}

void SetSpoolerSize(unsigned int NewBufSize)
{
  SpoolError = 0;
  if(!NewBufSize) {
    if(SpoolerInstalled)
      RestoreOldInterruptVectors();
    SpoolRec.Enabled = FALSE;
    return;
  }
  if(!SpoolerInstalled)
    SetUpNewInterruptVectors();
  DeallocateBuffer();
  AllocateBuffer(NewBufSize);
}

void StartSpooling(void)
{
  SpoolRec.Enabled = TRUE;
}

void StopSpooling(void)
{
  SpoolRec.Enabled = FALSE;
}

unsigned int CharsInSpooler(void)
{
  return SpoolRec.Tail - 1;
}
