/* filename: SCRFLDNO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <scrnedit.h>
  
extern InfoType Info;
  
unsigned char ScreenFieldNo(string10 ThisDBF, string10 ThisField)
// This procedure returns the "number" of the GetList record for ThisDBF and
// ThisField in the CurrentScreen's GetList.  This would be the equivalent
// of SGFieldCode, but the user is asking about some field other than the
// current one.
{
  GetListPtr GetRec;
  int Found;
  int Finished;
  unsigned char Number;
  
  if (!Info.CurrentScreen) {
    SetError(InvalidOperation, 6, doscreengets_not_active, "[ScreenFieldNo(",
    ThisDBF, ", ", ThisField, ")]");
    return 0;
  }
  // Find the first GetList record with matching DBFAlias and FieldName
  strcpy(ThisField, Upper(Trim(ThisField)));
  strcpy(ThisDBF, Upper(Trim(ThisDBF)));
  GetRec = Info.CurrentScreen->ScreenGets;
  Number = 1;
  Found = FALSE;
  Finished = FALSE;
  while (!Found && !Finished) {
    Finished = (GetRec == NULL);
    if (!Finished) {
      Found = (!strcmp(GetRec->FieldName, ThisField) &&
      (!strcmp(GetRec->DBFAlias, ThisDBF) ||
      (GetRec->DBFAlias[0] == 0) && !strcmp(Alias(), ThisDBF)));
      if (!Found) {
        // If the current GetRec record is a GET field then count it. SAY
        // fields don't count, because they were put on the screen with an AT
        // statement - so they aren't part of the series of SGFieldCode
        // values.
        if (GetRec->intMask & (SayOrGetMask == SayOrGetMask))
          ++Number;
        GetRec = GetRec->NextGet;
      }
    }
  }
  if (!Found) {
    SetError(InvalidParameter, 7, cannot_locate, ThisDBF, ".", ThisField, "\r\n",
    in_active_sayget_fields, "[ScreenFieldNo]");
    return 0;
  }
  return Number;
}
  
