/* filename: SCRFDNAM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <scrnedit.h>

extern InfoType Info;

static char funcname[] = { "[ScreenFieldNames]" };

void ScreenFieldNames(string10 * ThisDBF, string10 * ThisField)
/*  Returns the Field Name and Alias of the currently active data entry
field during DoScreenGets.  */
{
  unsigned char Count;
  GetListPtr GetRec;
  int HitTheEnd;
  char errmsg[STRSIZ];

  (*ThisDBF)[0] = 0;
  (*ThisField)[0] = 0;

  if (Info.CurrentScreen == NULL) {
    SetError(InvalidOperation, 2, doscreengets_not_active, funcname);
    return;
  }
  /*  Find the SGFieldCode'th record (that isn't a SAY field) in the
  CurrentScreen's GetList  */
  GetRec = Info.CurrentScreen->ScreenGets;
  if (GetRec)
      while ((GetRec != NULL) && ((GetRec->intMask & SayOrGetMask) == 0))
        GetRec = GetRec->NextGet;
  for (Count = 2; Count <= SGFieldCode; Count++) {
    HitTheEnd = (GetRec == NULL);
    if (!HitTheEnd)
      GetRec = GetRec->NextGet;
    if (GetRec)
      while ((GetRec != NULL) && ((GetRec->intMask & SayOrGetMask) == 0))
        GetRec = GetRec->NextGet;
  }
  if (!GetRec) {
    sprintf(errmsg, "%s\r\n%s(%d)%s", too_few_gets_in_current_screen,
      fewer_than_current_sgfieldcode, SGFieldCode, funcname);
    SetError(InvalidParameter, 1, errmsg);
    return;
  }
  else {
    strcpy(*ThisDBF, GetRec->DBFAlias);
    strcpy(*ThisField, GetRec->FieldName);
  }
}
