/* filename: CLRSCRGT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <scrnedit.h>

extern InfoType Info;

void DeallocateMemory(void ** LocPtr, unsigned Size);
ScreenListPtr SearchFor(string10 ScreenName);

extern InfoPtr InfoListTail;
extern ScreenListPtr ScreenListHead;

int InPushedInfoList(ScreenListPtr LookingFor)
{
  int Found = FALSE;
  InfoPtr InfoNode;

  InfoNode = InfoListTail;
  while (InfoNode) {
    if (InfoNode->CurrentScreen == LookingFor)
      Found = TRUE;
    InfoNode = InfoNode->LastInfoRecord;
  }
  return Found;
}

static void deallocStr(char ** p)
{
  if (*p)
    DeallocateMemory((void **) p, strlen(*p) + 1);
}

void ReturnGetRecord(GetListPtr GetPtr)
{
  // Before the storage for the GetList node can be returned, the
  // storage associated with any of it's void *s must be returned
  deallocStr(&GetPtr->FieldName);
  deallocStr(&GetPtr->PictureClause);
  deallocStr(&GetPtr->RangeLower);
  deallocStr(&GetPtr->RangeUpper);
  // Now we can get rid of the node itself.
  DeallocateMemory((void **) &GetPtr, sizeof(GetList));
}

void ClearScreenGets(string10 ScreenName)
{
  ScreenListPtr LastScreen;
  GetListPtr NextGet;
  ScreenListPtr ScreenHandle;
  GetListPtr ThisGet;
  char *ptr;

  ScreenHandle = SearchFor(ScreenName);
  if (!ScreenHandle) {
    ptr = screen_not_defined;
    goto bailout;
  }
  if (Info.CurrentScreen == ScreenHandle) {
    ptr = cannot_clear_active_screen;
    goto bailout;
  }
  if (InPushedInfoList(ScreenHandle)) {
    ptr = cannot_clear_pushed_screen;
    goto bailout;
  }
  ThisGet = ScreenHandle->ScreenGets;
  while (ThisGet) {
    NextGet = ThisGet->NextGet;
    ReturnGetRecord(ThisGet);
    ThisGet = NextGet;
  }
  // Clip the ScreenHandle node out of the ScreenList
  if (ScreenHandle == ScreenListHead)
    ScreenListHead = ScreenHandle->NextScreen;
  else {
    LastScreen = ScreenListHead;
    while (LastScreen->NextScreen != ScreenHandle)
      LastScreen = LastScreen->NextScreen;
    LastScreen->NextScreen = ScreenHandle->NextScreen;
  }
  // Finally, return the ScreenHandle node memory
  DeallocateMemory((void **) &ScreenHandle, sizeof(ScreenList));
  return;

bailout:
  SetError(InvalidOperation, 4, ptr, "[ClearScreenGets(", ScreenName, ")]");
}
