/* filename: ADDGETRC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <scrnedit.h>

extern InfoType Info;
extern char CallingRoutine[16];
extern string10 GlobalScreenName;

void AllocateMemory(void ** LocPtr, unsigned Size);

extern GetListPtr CurrentGet;

static BOOL AliasAndFieldOK(GetRecord *SqzGet)
{
  string10 AliasName;
  int SaveAutoHalt;
  char errmsg[STRSIZ];

  strcpy(AliasName, Trim(SqzGet->DBFAlias));

  /*  If NO Alias is specified, then we assume that the currently
  selected database is the correct database.  LoadScreenGets
  has already checked to be sure that there is a database open
  in the currently selected area.  */

  if (!AliasName[0])
    strcpy(AliasName, Trim(Alias()));
  else {
    SaveAutoHalt = AutoHalt;
    AutoHalt = FALSE;
    SelectAlias(SqzGet->DBFAlias);
    AutoHalt = SaveAutoHalt;
    if (DBFError) {
      sprintf(errmsg, "%s\"%s\"%s [%s(%s)]", unknown_alias, SqzGet->DBFAlias,
        _specified, CallingRoutine, GlobalScreenName);
      SetError(DBFError, 1, errmsg);
      return FALSE;
    }
  }
  if (!FieldNo(SqzGet->FieldName)) {
    sprintf(errmsg, "%s\"%s\"%s\"%s\". [%s(%s)]", _field, SqzGet->FieldName,
      not_in_alias, AliasName, CallingRoutine, GlobalScreenName);
    SetError(InvalidParameter, 1, errmsg);
    return FALSE;
  }
  return TRUE;
}

static void AssignDataType(GetListPtr NextGet, GetRecord *SqzGet)
{
  char DBFType, ft1;
  int FieldOK;
  int p, d, t;
  char errmsg[STRSIZ];

  DBFType = FieldType(NextGet->FieldNum);
  if (!Trim(SqzGet->FieldType)[0])
    sprintf(SqzGet->FieldType,"%c ", DBFType);

  p = *((int *) SqzGet->FieldType);
  d = SqzGet->FieldDecimals;
  switch (DBFType) {
    case 'C':
      FieldOK =  // "C" works with:
      ((p == 0x4843) || // Char "CH"
      (p == 0x2043) || // Char String "C "
      (p == 0x2053) || // String "S "
      (p == 0x5453) || // Static "ST"
      (p == 0x2054));  // Time "T "
      break;
    case 'D':  // "D" works with:
      FieldOK =
      ((p == 0x2044) || //  Date "D "
      (p == 0x4446));   // Fuzzy Date "FD"
      break;
    case 'F':
      FieldOK =
      ((p == 0x2046) || // Float "F "
      (p == 0x2052) ||  // Real "R "  or  Numeric..
      ((p == 0x204e) &&
      (d > 0)));   // ..Real
      break;
    case 'L':     // int
      FieldOK =
      ((p == 0x2042) || // "B "
      (p == 0x204c));   // Logical "L "
      break;
    case 'M':
      FieldOK = (p == 0x204d);   // Memo "M "
      break;
    case 'N':
      if (d > 0)   //  "N.x" works with:
        FieldOK =
        ((p == 0x2046) || // Float "F "
        (p == 0x2052) ||  // ..Real "R "
        (p == 0x204e));   // "N "
      else   //  "N.0" works with:
        FieldOK =   // Numeric..
        ((p == 0x5942) || // Byte "BY"
        (p == 0x2049) ||  // Integer "I "
        (p == 0x494c) ||  // LongInt "LI"
        (p == 0x4953) ||  // ShortInt "SI"
        (p == 0x2057) ||  // unsigned "W "
        ((p == 0x204e) && // "N "
        (d == 0)));
      break;
    default:
      FieldOK = FALSE;
      sprintf(errmsg, "%s\"%s\"\r\n%s\"%s\" [%s(%s)]", dbf_has_bad_field_type,
        DBFType, _field, SqzGet->FieldName, CallingRoutine, GlobalScreenName);
      SetError(InvalidParameter, 1, errmsg);
      break;
  }
  if (!FieldOK) {
    NextGet->SayGetType = _UNDEFINEDTYPE;
    sprintf(errmsg, "%s\"%s\"%s%s\"%s\"%s\r\n%s\"%s\" [%s(%s)]",
      dbf_field_type, DBFType, _and, sqz_field_type, SqzGet->FieldType,
      are_not_compatible, _field, SqzGet->FieldName, CallingRoutine,
      GlobalScreenName);
    SetError(InvalidParameter, 1, errmsg);
    return;
  }
  ft1 = SqzGet->FieldType[1];
  switch (SqzGet->FieldType[0]) {
    case 'B':
      if (ft1 == 'Y') // Byte
        t = _UC;
      else
        t = _L; // int
      break;
    case 'C':
      if (ft1 == 'H') // CHar
        t = _SC;
      else
        t = _S; // Character String
      break;
    case 'D':
      t = _D; // Date
      break;
    case 'F':
      if (ft1 == 'D') // _FD ?
        t = _D;  // Fuzzy Date
      else
        t = _DF; // Double float
      break;
    case 'I':
      t = _I;   // Integer
      break;
    case 'L':
      if (ft1 == 'I')   // Long Int
        t = _LI;
      else
        t = _L; // Logical
      break;
    case 'M':
      t = _M;   // Memo
      break;
    case 'N':
      if (d > 0) // Numeric Real
        t = _DF;
      else
        t = _LI; // Numeric Integer
      break;
    case 'R':
      t = _DF;   // Double float
      break;
    case 'S':
      if (ft1 == 'I')   // Short Int
        t = _SH;
      else {
        if (ft1 == 'T')   // Static
          t = _STATIC;
        else
          t = _S;   // String
      }
      break;
    case 'T':
      t = _T;   // Time
      break;
    case 'W':
      t = _UI;   // unsigned
      break;
    default:
      sprintf(errmsg, "%s\"%s\"%s\r\n%s\"%s\" [%s(%s)]", sqz_field_type,
        SqzGet->FieldType, is_not_a_topaz_data_type, _field,
        SqzGet->FieldName, CallingRoutine, GlobalScreenName);
      SetError(InvalidParameter, 1, errmsg);
  }
  if (t)
    NextGet->SayGetType = t;
}

static void CheckDataLengths(GetListPtr NextGet, GetRecord *SqzGet)
{
  char errmsg[STRSIZ];

  if (FieldLen(NextGet->FieldNum) < (unsigned char) SqzGet->FieldLength) {
    sprintf(errmsg, "%s(%d)%s(%d)\r\n%s\"%s\" [%s(%s)]", dbf_field_length,
        FieldLen(NextGet->FieldNum), is_shorter_than_sqz_field_length,
        SqzGet->FieldLength, _field, SqzGet->FieldName, CallingRoutine,
        GlobalScreenName);
    SetError(InvalidParameter, 1, errmsg);
  }
  if ((NextGet->FieldLength < strlen(SqzGet->PictureClause)) &&
  !strchr(SqzGet->PictureClause, '@') && (NextGet->SayGetType != _M)) {
    sprintf(errmsg, "%s\"%s\"%s(%d)\r\n%s\"%s\" [%s(%s)]",sqz_picture_clause,
      SqzGet->PictureClause, is_longer_than_field_length,
      NextGet->FieldLength, _field, SqzGet->FieldName, CallingRoutine,
      GlobalScreenName);
    SetError(InvalidParameter, 1, errmsg);
  }
}

static void makeNextGet(char * prev, char ** next)
{
  strcpy(prev, Trim(prev));
  if (prev[0]) {
    AllocateMemory((void **) next, strlen(prev) + 1);
    strcpy(*next, prev);
  }
}

void AddGetRecord(GetRecord * SqzGet)
{
  GetListPtr NextGet;
  unsigned char SaveArea;

  SaveArea = CurrentArea();

  //  This will potentially change the current work area
  if (AliasAndFieldOK(SqzGet)) {
    if (coreleft() < (sizeof(GetList) + 90)) {
      DBFError = InsufficientMemory;
      SetError(DBFError, 5, "[", CallingRoutine, "(",
      GlobalScreenName, ")]");
      return;
    }
    //  Now we're ready to build the data into the record to be saved.
    AllocateMemory((void **) &NextGet, sizeof(GetList));
    memset(NextGet, 0, sizeof(GetList));  //  so all void *s are NULL
    //  First, deal with all the vars that are a fairly straight transfer.
    NextGet->Column = SqzGet->Column;
    NextGet->Row = SqzGet->Row;
    strcpy(NextGet->DBFAlias,Upper(Trim(SqzGet->DBFAlias)));
    NextGet->Foreground = SqzGet->Foreground;
    NextGet->BackGround = SqzGet->BackGround;
    NextGet->FieldNum = FieldNo(SqzGet->FieldName);
    if (SqzGet->FieldLength > 0) {
      NextGet->FieldLength = SqzGet->FieldLength;
      NextGet->FieldDecimals = SqzGet->FieldDecimals;
    }
    else {
      NextGet->FieldLength = FieldLen(NextGet->FieldNum);
      NextGet->FieldDecimals = FieldDec(NextGet->FieldNum);
    }
    //  Next, deal with the strings that we have to GETMEM space for
    makeNextGet(SqzGet->FieldName, &NextGet->FieldName);
    makeNextGet(SqzGet->PictureClause, &NextGet->PictureClause);
    makeNextGet(SqzGet->RangeLower, &NextGet->RangeLower);
    makeNextGet(SqzGet->RangeUpper, &NextGet->RangeUpper);
    /*  Next, assign the SayGet Data type, based on the field's data type.
    The Assign procedure also checks for SQZ and DBF type compatibility.
    The Check lengths procedure checks to be sure appropriate lengths
    have been specified for SQZ and DBF data field and Picture clause.  */
    AssignDataType(NextGet, SqzGet);
    CheckDataLengths(NextGet, SqzGet);
    //  Next, build the intMask from the TRUE SqzGet ints.
    if (SqzGet->SayOrGet)
      NextGet->intMask |= SayOrGetMask;
    if (SqzGet->NoEdit)
      NextGet->intMask |= NoEditMask;
    if (SqzGet->BlankField)
      NextGet->intMask |= BlankFieldMask;
    if (SqzGet->Required)
      NextGet->intMask |= RequiredMask;
    //  Now that the NextGet record has been built, we need to add it to
    // the GetList for the current screen.
    //  Then this is the first GET for this screen
    if (CurrentGet == NULL)
      Info.CurrentScreen->ScreenGets = NextGet;
    else
      CurrentGet->NextGet = NextGet;
    CurrentGet = NextGet;
  }
  Select(SaveArea);
}
