/* filename: SETCNTRY.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>

#include <sayget.h>

char * BooleanSet = "YNTFyntf";
char * TrueSet  = "YT";
char * FalseSet = "N F";

struct CountryCodes {
  char true[3];
  char false[4];
  char boolsayset[3];
  char boolset[9];
  char dec;
  char thousand;
};

static struct CountryCodes _tzfar CodesOf[6] = {
  { "YT", "N F", "NY", "YyNnTtFf", '.', ',' }, // USA, Britain
  { "SV", "N I", "NS", "SsNnVvIi", ',', '.' }, // Italy
  { "OV", "N I", "NO", "OoNnVvIi", ',', '.' }, // France, Quebec
  { "JR", "N F", "NJ", "JjNnRrFf", ',', '.' }, // Germany
  { "SV", "N F", "NS", "SsNnVvFf", ',', '.' }, // Spain
  { "\x84X", "\x8D  ", "\x8D\x84", "\x84\xA4\x8D\xADXx  ", '.', ' ' } // Russia
};

void SetCountryTo(char country)
{
  struct CountryCodes *cc;

  if ((country < USA) || (country > Russia))
    country = USA;
  Country = country;
  SetDate(country);
  switch (country) {
    case Italy:   country = 1; break;
    case France:
    case Quebec:  country = 2; break;
    case Germany: country = 3; break;
    case Spain:   country = 4; break;
    case Russia:  country = 5; break;
    case USA:
    case Britain:
    default:       country = 0; break;
  }
  cc = &CodesOf[country];
  strcpy(TrueSet, cc->true);
  strcpy(FalseSet, cc->false);
  strcpy(BooleanSaySet, cc->boolsayset);
  strcpy(BooleanSet, cc->boolset);
  DecimalSymbol = cc->dec;
  ThousandsSeparator = cc->thousand;
}
