/* filename: RINGBELL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
  
#include <stdio.h>
#include <dos.h>
  
#include <sayget.h>
#ifdef _MSC_VER
#include <time.h>
#include <conio.h>
  
// Use intrinsic versions of _outp and _inp
#pragma optimize( "i",on )
  
// Sounds the speaker for a time specified in microseconds by duration
// at a pitch specified in hertz by frequency.

void Beep( int frequency, int duration )
{
  int control;
  
  // If frequency is 0, Beep doesn't try to make a sound. It
  // just sleeps for the duration.
  if( frequency ) {
    // 75 is about the shortest reliable duration of a sound.
    if( duration < 75 )
      duration = 75;
  
    // Prepare timer by sending 10111100 to port 43.
    _outp( 0x43, 0xb6 );
  
    // Divide input frequency by timer ticks per second and
    // write (byte by byte) to timer.

    frequency = (unsigned)(1193180L / frequency);
    _outp( 0x42, (char)frequency );
    _outp( 0x42, (char)(frequency >> 8) );
  
    // Save speaker control byte.
    control = inp( 0x61 );
  
    // Turn on the speaker (with bits 0 and 1).
    _outp( 0x61, control | 0x3 );
  }
  
  delay( duration );
  
  // Turn speaker back on if necessary.
  if( frequency )
    _outp( 0x61, control );
}
#pragma optimize( "",on )
  
void RingBell(void)
{
  int itemp = BellCount;
  
  while (itemp > 0) {
    Beep( BellPitch, BellDuration );
    --itemp;
    if (itemp > 0)
      delay(BellDuration);
  }
}
#else
void RingBell(void)
{
  int itemp = BellCount;
  
  nosound();
  while (itemp > 0) {
    sound(BellPitch);
    delay(BellDuration);
    nosound();
    --itemp;
    if (itemp > 0)
      delay(BellDuration);
  }
}
#endif // _MSC_VER
#endif // Not Windows
