/* filename: RANGE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <string.h>

#include <sayget.h>

void Range(char * lower, char * upper)
{
  SGFieldRecord *with;
  float lowconst, highconst;
  char *lowstr, *highstr;
  int flag = 1;
  VarTypes vartype;

  if (TableSize[SGwhich] > 0) {
    with = GetTable[SGwhich][TableSize[SGwhich]-1];
    vartype = with->vartype;
    if ((vartype != _L) && (vartype != _UNDEFINEDTYPE) &&
        (vartype != _S) && (vartype != _M) && (vartype != _STATIC)) {
      with->RangeChecking = TRUE;
      strcpy(with->LowerLimit, lower);
      strcpy(with->UpperLimit, upper);
      switch (vartype) {
        case _UC:
          lowconst = 0.0F;
          highconst = 255.0F;
          lowstr = "0";
          highstr = "255";
          break;
        case _SC:
          lowconst = -128.0F;
          highconst = 127.0F;
          lowstr = "-128";
          highstr = "127";
          break;
        case _LI:
          lowconst = -2147483648.0F;
          highconst = 2147483647.0F;
          lowstr = "-2,147,483,648";
          highstr = "2,147,483,647";
          break;
        case _UL:
          lowconst = 0.0F;
          highconst = 4294967295.0F;
          lowstr = "0";
          highstr = "4,294,967,295";
          break;
        case _SH:
        case _I:
          lowconst = -32768.0F;
          highconst = 32767.0F;
          lowstr = "-32768";
          highstr = "32767";
          break;
        case _US:
        case _UI:
          lowconst = 0.0F;
          highconst = 65535.0F;
          lowstr = "0";
          highstr = "65535";
          break;
        default:
          flag = 0;
          break;
      } // case
      if (flag) {
        if (RealVal(lower) < lowconst)
          strcpy(with->LowerLimit, lowstr);
        if (RealVal(upper) > highconst)
          strcpy(with->UpperLimit, highstr);
      }
    }
  }
} // Range
#endif
