/* filename: PRREADY.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
  
#include <sayget.h>
  
BOOL PrinterReady(char lpt)
{
  union MYREGS cpu;
  
  /* status bit assignments:
  bit 4 = SELECTED       = (cpu.ah and $10) = $10
  bit 5 = OUT OF PAPER   = (cpu.ah and $20) = $20
  bit 7 = BUSY           = (cpu.ah and $80) = $80
  
  so PrinterReady := SELECTED and (not OUT OF PAPER)
  --BUSY is not at issue here--
  */
  if (UserPrinterCheck != NULL) {
    if( UserPrinterCheck() )
      return TRUE;
    else
      return FALSE;
  }
  else {
    memset((void *)&cpu.x,0,sizeof(cpu));
    cpu.h.ah = 0x02;
    if( (lpt<1) || (lpt>4) )
      lpt = 1;
    cpu.x.r_dx = lpt - 1;
    intr(0x17,&cpu.x);
    return ((cpu.h.ah & 0x10) == 0x10) && ((cpu.h.ah & 0x20) != 0x20);
  }
}
