/* filename: LOWBOX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
  
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <sayget.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
  
char LitColor, UnLitColor;
BOOL Chiselled;
  
void SetColor(int color)
{
#ifdef _MSC_VER
  _settextcolor(color & 0x0F);
  _setbkcolor((color & 0xF0) >> 4);
#else
  textattr(color); // modify byte in CRT unit to set colors
#endif
}
  
void LowLevelBox(int c1, int r1, int c2, int r2, char linestyle, const char * header)
{
  typedef enum {  TLCorner,BHorizontal,THorizontal,TRCorner,
  VerticalLine,BLCorner,BRCorner } BoxPart;
  char *SymbolSet[5] = {
    "\xDA\xC4\xC4\xBF\xB3\xC0\xD9",   // single line box chars
    "\xC9\xCD\xCD\xBB\xBA\xC8\xBC",   // double line box chars
    "\xDB\xDC\xDF\xDB\xDB\xDB\xDB",   // solid line box chars
    "\xD6\xC4\xC4\xB7\xBA\xD3\xBD",   // double sides, single top/bottom
    "\xD5\xCD\xCD\xB8\xB3\xD4\xBE" }; // single sides, double top/bottom
  char *ss;
  int i, width;
  int ShadowFlag, ShadowWidth;//, c1 = cc1, r1 = rr1, c2 = cc2, r2 = rr2;
  BOOL RaisedFlag, RecessedFlag;
  
  char *cst = " ";
  char charbuf, *ptr, col1, col2;
#ifdef _MSC_VER
  short sr1,sc1,sr2,sc2;
  
  _gettextwindow(&sr1, &sc1, &sr2, &sc2);
  SetColor(SayColor);
  if (ClearBoxes) {
    _settextwindow(r1,c1,r2,c2);
    _clearscreen(_GWINDOW);
  }
  _settextwindow(1,1,MaxAvailRows(),80);
#else
  struct text_info ti;
  
  gettextinfo(&ti);
  SetColor(SayColor); // modify byte in CRT unit to set colors
  if (ClearBoxes) {
    window(c1,r1,c2,r2);
    clrscr();
  }
  window(1,1,80,MaxAvailRows());
#endif
  // extract the various flags, then remove them from linestyle
  if (((linestyle & 0x0F) < 0) || ((linestyle & 0x0F) > 5) )
    linestyle = SingleLine;
  ShadowFlag = ((linestyle & Shadow) == Shadow); // the user has asked for a shadow
  // if background color is not black, look for Raised and Recessed flag bits,
  // otherwise, if background is black, or bright (msb is hi) then
  // Raised and Recessed can not be implemented
  if (      //  black condition           bright condition
    !( ((SayColor >> 4) == 0) || (((SayColor >> 4) & 0x08) == 0x08))) {
    RaisedFlag = linestyle & Raised;
    RecessedFlag = linestyle & Recessed;
    if (RaisedFlag && RecessedFlag)
      RecessedFlag = 0;
  }
  else
    RaisedFlag = RecessedFlag = FALSE;
  linestyle &= 0x0F;
  ss = SymbolSet[linestyle-1];
  
  // if chiselled, deal with color issue
  col1 = (SayColor >> 4) + (SayColor & 0xF0) + 8; // lightbackground
  col2 = BLACK + (SayColor  & 0xF0); // black on whatever background
  if (RaisedFlag) {
    LitColor = col1;
    UnLitColor = col2;
  }
  if (RecessedFlag) {
    LitColor = col2;
    UnLitColor = col1;
  }
  Chiselled = RaisedFlag || RecessedFlag;
  
  width = c2 - c1;
  
  if ((linestyle>0) && (linestyle < 6)) {
    // draw horizontal lines
    FastWrite((char _far *)(Replicate(ss[THorizontal], width + 1)),r1,c1, Chiselled ? LitColor  : SayColor);
    FastWrite((char _far *)(Replicate(ss[BHorizontal], width + 1)),r2,c1,Chiselled ? UnLitColor : SayColor);
    // draw vertical lines
    *cst = ss[VerticalLine];
    for (i = r1+1; i < r2; i++) {
      FastWrite((char _far *)cst,i,c1,Chiselled ? LitColor : SayColor);
      FastWrite((char _far *)cst,i,c2,Chiselled ? UnLitColor : SayColor);
    }
    // drop in the corner pieces
    *cst = ss[TLCorner];
    FastWrite((char _far *)cst,r1,c1, Chiselled ? LitColor : SayColor);
    *cst = ss[TRCorner];
    FastWrite((char _far *)cst,r1,c2, Chiselled ? UnLitColor : SayColor);
    *cst = ss[BLCorner];
    FastWrite((char _far *)cst,r2,c1,Chiselled ? LitColor : SayColor);
    *cst = ss[BRCorner];
    FastWrite((char _far *)cst,r2,c2,Chiselled ? UnLitColor : SayColor);
  
  } // finished drawing and painting lines of the box
  
  if (ShadowFlag) {
    // watch out for the edges of the screen
    ShadowWidth = 0;
    if (c2 == 79) ShadowWidth = 1;
    if (c2 <= 78) ShadowWidth = 2;
    if (ShadowWidth > 0)
      for (i = r1; i <= r2; i++)
        Paint(c2+1,i+1,(char)ShadowWidth,ShadowColor,BLACK);
    ShadowWidth += width - 1; // ShawdowWidth is now the length of the shadow
    if ((ShadowWidth > 0) && (r2 < (int)MaxAvailRows()))
      Paint(c1 + 2,r2+1,(char)ShadowWidth,ShadowColor,BLACK);
  }
  // if there is a header, and it fits, display it in the GET color
  if (header[0]) {
    if ((int)strlen(header) > width) {
      charbuf = header[width-1];
      ptr = (char *)&header[width-1];
      *ptr = 0;
    }
    else
      charbuf = 0;
    FastWrite((char _far *)(header),r1,c1 + 1 + (width - strlen(header)) / 2,SayColor);
    if(charbuf)
      *ptr = charbuf;
  }
  // restore the old window
#ifdef _MSC_VER
  _settextwindow(sr1,sc1,sr2,sc2);
#else
  window(ti.winleft, ti.wintop, ti.winright, ti.winbottom );
#endif
  TellDesqViewAboutChange();
}
#endif
