/* filename: BOX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <conio.h>
#include <sayget.h>

unsigned char ExplodeRate  = 20;
ExplodeModeType ExplodeMode  = CONTEXT;
int ClearBoxes = TRUE;

void Box(int c1, int r1, int c2, int r2, char linestyle, const char * header)
{
  char SaveX, SaveY;
  int SaveOrder;
  double ccenter, rcenter;
  double ExpandR, ExpandC, _c1, _c2, _r1, _r2;
  int ExplodeFlag;

  if (!CheckRegisteredUnits("Box", REGTZCOMMON+REGTZSAYGET))
    return;

  SaveX = wherex();
  SaveY = wherey();
  SaveOrder = dBASEOrder;

  if (dBASEOrder) {
    Convert(&c1,&r1);
    Convert(&c2,&r2);
    dBASEOrder = FALSE;
  }
  // determine from ExplodeMode and Linestyle whether we are exploding or not:
  switch (ExplodeMode) {
    case ALWAYS:    ExplodeFlag = TRUE;
      break;
    case NEVER:     ExplodeFlag = FALSE;
      break;
    case CONTEXT:   ExplodeFlag = (linestyle & Explode) == Explode;
      break;
    default:
      ExplodeFlag = FALSE;
  }
  // now remove the explode bit from linestyle:
  linestyle = linestyle & 0xBF;

  if (ExplodeFlag) { // explode the box, find the center of the box
    // call low level box until "next time is too big"
    ccenter = (c1 + c2) / 2;
    rcenter = (r1 + r2) / 2;
    ExpandC = (c2 - c1) / 20.0;
    ExpandR = (r2 - r1) / 20.0;

    _c1 = ccenter - ExpandC + 1;
    _c2 = ccenter + ExpandC + 1;
    _r1 = rcenter - ExpandR + 1;
    _r2 = rcenter + ExpandR + 1;

    while( ((int)_c1 > c1) || ((int)_c2 < c2) || ((int)_r1 > r1) || ((int)_r2 < r2))
    {
      if( (int)_c1 < c1)      _c1 = c1;
      if( (int)_c2 > c2)      _c2 = c2;
      if( (int)_r1 < r1)      _r1 = r1;
      if( (int)_r2 > r2)      _r2 = r2;
      LowLevelBox((int)_c1,(int)_r1,(int)_c2,(int)_r2,linestyle,header);
      delay(ExplodeRate);
      _c1 = _c1 - ExpandC;
      _c2 = _c2 + ExpandC;
      _r1 = _r1 - ExpandR;
      _r2 = _r2 + ExpandR;
    }
  } // of explosion
  LowLevelBox(c1,r1,c2,r2,linestyle,header);
  gotoxy(SaveX,SaveY);
  dBASEOrder = SaveOrder;
}
#endif
