/* filename: TZSAVER.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
#include <saver.h>

#ifdef _MSC_VER
#pragma optimize("i", on)
#pragma check_stack(off)
#pragma check_pointer(off)
#else
#pragma warn -eff
#pragma option -N- -k+
#endif

typedef void (interrupt _far *ISR)(void);
typedef unsigned char uchar;
typedef unsigned int uint;

static uint *SourcePtr;
static uint *DestPtr;
static uint *TopWinPtr;
static uchar Width;
static uchar ISRHandle;
static uchar SSType         = 0;
static uchar X1             = 1;
static uchar X2             = 80;
static uchar Y1             = 1;
static uchar Y2             = 25;
static uchar SSLineStyle    = 0;
static uchar Counter        = 0;
static uchar flystop        = 0;
static uchar Color          = 0;
static uchar tempX          = 0;
static uchar Count          = 0;
static uchar longv          = 0;
static uchar toggle         = 0;
static char  _tzfar SSHeader[81] = "";
static int   ScreenSaverOn  = FALSE;
static int   Streamer_Going = FALSE;
static int   FlyPos         = 79;
static int   Toggle         = FALSE;
static int   secondcounter  = 0;
static int   Right          = TRUE;
static int   WasVisible;
static int   SSinUse;        // avoids recursion in ISR
static int   streamer;
static int   x, y, d, d2;
static ISR   SaveVector;

#define getChar(_y, _x) *(char far *)MK_FP(BaseOfScreen, 160*((_y)-1)+(((_x)-1)<<1))
#define FW  FastWrite // just to save my fingers

#ifdef _MSC_VER
#define textcolor(x)       _settextcolor((short)(x))
#define textbackground(x)  _setbkcolor((long)(x))
#define textattr(x)        textcolor(x & 0xf); textbackground((x & 0xf0) >> 4)
#define random(__n)        (int)(((long)rand()*(__n))/((unsigned)RAND_MAX+1))
#endif

void WaitForPassword(char *password)
{
  char Temp[STRSIZ];
  int  SaveHelpOn;
  char Key[2];

  if(!CaseSensitivePassword)
    strupr(password);
  *Temp = 0;
  *(Key + 1) = 0;
  SaveHelpOn = HelpEnabled;
  HelpEnabled = FALSE;
  do {
    *Key = getch();
    if(*Key) {
      if(!CaseSensitivePassword)
        *Key = toupper(*Key);
      strcat(Temp, Key);
      if(strncmp(password, Temp, strlen(Temp)))
        *Temp = 0;
    }
  } while(strcmp(Temp, password));
  HelpEnabled = SaveHelpOn;
}

static void SetWindowPointers(unsigned char c1, unsigned char r1,
                              unsigned char c2, unsigned char r2)
{
  TopWinPtr = (uint far *) MK_FP(BaseSeg, VideoOffset);
  DestPtr   = TopWinPtr;
  DestPtr  += ((r2 - 1) << 6) + ((r2 - 1) << 4) + (c1 - 1);
  // DestPtr now points to c1, r2, i.e., the start of the last row of window
  SourcePtr = DestPtr - 80;
  // SourcePtr points to start of next-to-last row of window
  Width = (c2 - c1 + 1) << 1;
  // window width in bytes
  TopWinPtr += ((r1 - 1) << 6) + ((r1 - 1) << 4) + (c1 - 1);
  // TopWinPtr now points to first row in the window..we will use it as
  // signal of when to stop the repeat loop
}

#ifndef _MSC_VER
 #pragma argsused
#else
 #pragma optimize("e", off)
#endif
// Fill memory starting at Dest with Count instances of Filler
static void FillWord(void far *Dest, unsigned int Count, unsigned int Filler)
{
  _asm {
    mov di, [bp+6]  // DI = OFFSET  Dest
    mov ax, [bp+8]  // ES = SEGMENT Dest
    mov es, ax
    mov cx, [bp+10] // CX = Count
    mov ax, [bp+12] // AX = Filler
    cld             // go forward
    rep stosw       // fill memory
  }
}

static void WindowInsertLine(void)
{
  uint *mSourcePtr;
  uint *mDestPtr;

  mSourcePtr = SourcePtr;   // don't mess with original pointers
  mDestPtr   = DestPtr;
  if(MouseDriverPresent) {  // Hide mouse pointer
    _asm mov ax, 0x2
    _asm int 0x33
  }
  do {
    memmove(mDestPtr, mSourcePtr, Width); // copy from a row to the next row
    mDestPtr = mSourcePtr;                // move up one row
    mSourcePtr -= 80;
  } while(mDestPtr != TopWinPtr);          // until all rows have been copied
  FillWord(TopWinPtr, Width >> 1, 0x0720); // now blank the first row, and we are done
  if(MouseDriverPresent) {                 // Show mouse poinet
    _asm mov ax, 0x1
    _asm int 0x33
  }
}

#ifdef _MSC_VER
 #pragma optimize("", on)
#endif

static int TextAttr(void)
{
#ifndef _MSC_VER
  struct text_info r;

  gettextinfo(&r);
  return r.attribute;
#else
  return (int)(_getbkcolor() << 8 ) | _gettextcolor();
#endif
}

static void DrawConfetti(void)
{
  static char ConfettiSymbols[] = " \xDC\xDF\x04\xFE\x16\x1F\0x03";
  char symbol[2];

  *(symbol + 1) = 0;
  if(BaseOfScreen == 0xB800)
    textcolor(random(15) + 1);
  else
    textcolor(random(2) ? 15 : 2);
  x = random(X2 - X1 + 1) + X1;
  y = random(Y2 - Y1 + 1) + Y1;
  if(++toggle > 3)
    toggle = 1;
  *symbol = ConfettiSymbols[toggle];
  if(!strchr("\xDD\xDE", getChar(y, x)))
    FW(symbol, y, x, TextAttr());
}

static void DrawStreamer(void)
{
  if(Streamer_Going) {
    Count++;
    if(Count > longv) {
      Count = longv = 0;
      Streamer_Going = streamer = FALSE;
      return;
    }
    FW((Count & 1) ? "\xDE" : "\xDD", Y1, tempX, Color);
  } else {
    Count++;
    Streamer_Going = TRUE;
    longv = random(7) + 3;
    tempX = random(X2 - X1 + 1) + X1;
    if(BaseOfScreen == 0xB800)
      Color = random(15) + 1;
    else
      Color = random(2) ? 15 : 0;
    FW("\xDD", Y1, tempX, Color);
  }
}

static void LowLevelScreenSaver1(void)
{
  uchar SaveTextAttr;
  int           s;

  SaveTextAttr = TextAttr();
  textbackground(0);
  SetWindowPointers(X1, Y1, X2, Y2);
  // does this need to be set each time?
  switch(Counter) {
    case 0:
      Counter = 1;
      Streamer_Going = FALSE;
      Color = tempX = Count = longv = 0;
      break;

    case 1:
      Counter++;
      break;

    case 2:
      if(streamer)
        DrawStreamer();
      s = random(10) + 1;
      while(s--)
        DrawConfetti();
      if(!streamer) {
        x = random(10);
        if(x == random(10))
          streamer = TRUE;
      }
      Counter = 1;
      WindowInsertLine();
      break;
  }
  textattr(SaveTextAttr);
}

static void LowLevelScreenSaver2(void)
{
  static char Space[]     = " ";
  static char FourSpace[] = "    ";
  static char Rocket[]    = "\x5";
  static char Flames[]    = "V";
  static char AtSign[]    = "@";
  static char BSlash[]    = "\\";
  static char Period[]    = ".";
  static char Percent[]   = "%";
  static char Pipette[]   = "\xB3";
  static char Hyphen[]    = "-";
  static char Star[]      = "*";
  uchar       SaveTextAttr;

  SaveTextAttr = TextAttr();
  switch(Counter) {
    case 0:
      Counter++;
      d2 = x = d = 0;
      break;

    case 1:
      Counter++;
      x = random(X2 - X1 + 1) + X1 + 2;
      if(x + 2 >= (int) X2)
        x = X2 - 1;
      d = Y2;     // maxavailrows
      d2 = random(Y2 - Y1 + 1) + Y1 + 1;
      if(d2 >= (int) Y2)
        d2 = Y2 - 1;
      break;

    case 2:
      FW(Rocket, d, x, WHITE);
      if(d < (int) Y2)
        FW(Flames, d + 1, x, LIGHTRED);
      if(d + 2 <= (int) Y2)
        FW(Space, d + 2, x, BLACK);
      d--;
      if(d == d2)
        Counter = 5;
      break;

    case 5:
      Counter = 6;
      if(d + 2 <= (int) Y2)
        FW(Space, d + 2, x, BLACK);
      FW(BSlash,  d - 1, x - 2, LIGHTRED);
      FW(Pipette, d - 1, x - 1, LIGHTRED);
      FW(AtSign,  d - 1, x,     WHITE);
      FW(Hyphen,  d,     x - 2, LIGHTRED);
      FW(AtSign,  d,     x - 1, WHITE);
      FW(AtSign,  d,     x,     WHITE);
      FW(Hyphen,  d,     x + 1, LIGHTRED);
      FW(AtSign,  d + 1, x - 2, WHITE);
      FW(Pipette, d + 1, x - 1, LIGHTRED);
      FW(BSlash,  d + 1, x,     LIGHTRED);
      break;

    case 8:
      Counter = 9;
      FW(BSlash,  d - 1, x - 2, LIGHTRED);
      FW(Period,  d - 1, x - 1, LIGHTRED);
      FW(AtSign,  d - 1, x,     WHITE);
      FW(Period,  d - 1, x + 1, LIGHTRED);
      FW(AtSign,  d,     x - 2, WHITE);
      FW(Star,    d,     x - 1, YELLOW);
      FW(Period,  d,     x,     LIGHTRED);
      FW(AtSign,  d,     x + 1, WHITE);
      FW(Percent, d + 1, x - 2, LIGHTRED);
      FW(Period,  d + 1, x - 1, LIGHTRED);
      FW(AtSign,  d + 1, x,     WHITE);
      break;

    case 11:
      Counter = 12;
      FW(". .",  d - 1, x - 2, LIGHTRED);
      FW(".  .", d,     x - 2, LIGHTRED);
      FW(" . ",  d + 1, x - 2, LIGHTRED);
      break;

    case 14:
      Counter = 15;
      FW(FourSpace, d - 1, x - 2, BLACK);
      FW(FourSpace, d,     x - 2, BLACK);
      FW(FourSpace, d + 1, x - 2, BLACK);
      break;

    case 6:
    case 7:
    case 9:
    case 10:
    case 12:
    case 13:
    case 15:
    case 16:
      Counter++;   // for delay purposes
      break;

    case 17:
      Counter = 1;
      break;
  }
  textattr(SaveTextAttr);
}

static void LowLevelScreenSaver3(void)
{
  static char spider1[]    = "/^\\";
  static char spider2[]    = "\\^/";
  static char spiderbody[] = "\xEA";
  static char lleg[]       = "\xD4";
  static char rleg[]       = "\xBE";
  static char webbing[]    = "\xB3";
  static char Flywing1[]   = "8";
  static char Flywing2[]   = "\xE1";
  static char Flybody[]    = "\xEC";
  static char Space[]      = " ";
  static char flywing[]    = " ";
  static char character[]  = "   ";
  static char FourSpace[]  = "    ";
  uchar       SaveTextAttr;

  SaveTextAttr = TextAttr();
  switch(Counter) {
    case 0:
      Counter++;
      d2 = d = 0;
      Toggle = FALSE;
      Right  = TRUE;
      flystop = 0;
      secondcounter = 0;
      break;

    case 1:
      // compute positions, etc.
      secondcounter = 1;
      flystop = random(X2 - X1 + 1) + X1 + 3;
      if((int) flystop + 2 >= (int) X2)
        flystop = X2 - 2;
      d  = Y1;
      d2 = random(Y2 - Y1 + 1) + Y1 + 1;
      if(d2 >= (int) Y2)
        d2 = Y2 - 1;
      Counter++;
      if(random(2) + 1 == 1) {
        FlyPos = X1;
        Counter++;
        *Flybody  = '\xE5';
        *Flywing2 = 0x26;
        Right = TRUE;
        FW(Flybody, d2, FlyPos, YELLOW);
      } else {
        Right       = FALSE;
        FlyPos = SSLineStyle ? (X2 - 1) : X2;
        *Flywing2   = '\xE1';
        *Flybody    = '\xEC';
        FW(Flybody, d2, FlyPos, YELLOW);
      }
      break;

    case 2: // send the fly on its way to the left
      FW(Space, d2, FlyPos, YELLOW);
      if(!(++secondcounter & 1)) {
        if(--FlyPos < (int) flystop)
          FlyPos = flystop;
      } else  // random walk
        if(FlyPos >= (int) flystop) {
          FlyPos = FlyPos + random(3) - 1; // add to x -1,0,1
          if(FlyPos > X2 - 2)
            FlyPos = X2 - 2;
          d2 = d2 + random(3) - 1;  // add to y -1,0,1
          if(d2 > Y2 - 1)
            d2 = Y2 - 1;
          if(d2 < Y1 + 1)
            d2 = Y1 + 1;
        }
      Toggle = !Toggle;
      *flywing = Toggle ? *Flywing1 : *Flywing2;
      if(FlyPos < X2 - 1) {
        FW(Flybody, d2, FlyPos,     YELLOW);
        FW(flywing, d2, FlyPos + 1, YELLOW);
        FW(Space,   d2, FlyPos + 2, YELLOW);
      }
      if(FlyPos > X1 + 1) {
        FW(Space,   d2, FlyPos - 1, YELLOW);
        FW(Flybody, d2, FlyPos,     YELLOW);
        FW(flywing, d2, FlyPos + 1, YELLOW);
      }
      if(d2 < Y2 - 1)
        FW(FourSpace, d2 + 1, FlyPos - 1, BLACK);
      if(d2 > Y1 + 1)
        FW(FourSpace, d2 - 1, FlyPos - 1, BLACK);
      if(FlyPos <= (int) flystop) {
        Counter = 4;
        secondcounter = 0;
      } else
        Counter = 2;
      break;

    case 3: // send the fly on its way to the right
      FW(Space, d2, FlyPos, YELLOW);
      if(!(++secondcounter & 1)) {
        if(++FlyPos > (int) flystop)
          FlyPos = flystop;
      } else // random walk
        if(FlyPos <= (int) flystop) {
          FlyPos = FlyPos + random(3) - 1; // add to x -1,0,1
          if(FlyPos < X1 + 2)
            FlyPos = X1 + 2;
          if(FlyPos > X2 - 2)
            FlyPos = X2 - 2;
          d2 = d2 + random(3) - 1; // add to y -1,0,1
          if(d2 > Y2 - 1)
            d2 = Y2 - 1;
          if(d2 < Y1 + 1)
            d2 = Y1 + 1;
        }
      Toggle = !Toggle;
      *flywing = Toggle ? *Flywing1 : *Flywing2;
      if(FlyPos < X2 - 2) {
        FW(flywing, d2, FlyPos,     YELLOW);
        FW(Flybody, d2, FlyPos + 1, YELLOW);
        FW(Space,   d2, FlyPos + 2, YELLOW);
      }
      if(FlyPos > X1 + 1) {
        FW(Space,   d2, FlyPos - 1, YELLOW);
        FW(flywing, d2, FlyPos,     YELLOW);
        FW(Flybody, d2, FlyPos + 1, YELLOW);
      }
      if(d2 < Y2 - 1)
        FW(FourSpace, d2 + 1, FlyPos - 1, BLACK);
      if(d2 > Y1 + 1)
        FW(FourSpace, d2 - 1, FlyPos - 1, BLACK);
      if(FlyPos >= (int) flystop) {
        Counter = 4;
        secondcounter = 0;
      } else
        Counter = 3;
      break;

    case 4: // hover
      secondcounter++;
      Toggle = !Toggle;
      *flywing = Toggle ? *Flywing1 : *Flywing2;
      if(!Right) {
        if(FlyPos < X2 - 2) {
          FW(Flybody, d2, FlyPos,     YELLOW);
          FW(flywing, d2, FlyPos + 1, YELLOW);
          FW(Space,   d2, FlyPos + 2, YELLOW);
        }
        if(FlyPos > X1 + 1) {
          FW(Space,   d2, FlyPos - 1, YELLOW);
          FW(Flybody, d2, FlyPos,     YELLOW);
          FW(flywing, d2, FlyPos + 1, YELLOW);
        }
      } else {
        if(FlyPos < X2 - 2) {
          FW(flywing, d2, FlyPos,     YELLOW);
          FW(Flybody, d2, FlyPos + 1, YELLOW);
          FW(Space,   d2, FlyPos + 2, YELLOW);
        }
        if(FlyPos > X1 + 1) {
          FW(Space,   d2, FlyPos - 1, YELLOW);
          FW(flywing, d2, FlyPos,     YELLOW);
          FW(Flybody, d2, FlyPos + 1, YELLOW);
        }
      }
      if(d2 < Y2 - 1)
        FW(FourSpace, d2 + 1, FlyPos - 1, BLACK);
      if(d2 > Y1 + 1)
        FW(FourSpace, d2 - 1, FlyPos - 1, BLACK);
      if(secondcounter >= 15)
        Counter = 5;
      else
        Counter = 4;
      break;

    case 5: // hover spider descends
      if(Right)
        *Flywing2 = 0x26;
      Toggle = !Toggle;
      strcpy(character, (Toggle ? spider1 : spider2));
      *flywing = Toggle ? *Flywing1 : *Flywing2;
      FW(character, d, FlyPos - 1, LIGHTRED);
      if(d > Y1 + 1) {
        FW(Space,   d - 2, FlyPos - 1, BLACK);
        FW(webbing, d - 2, FlyPos,     WHITE);
        FW(Space,   d - 2, FlyPos + 1, BLACK);
      }
      if(d > (int) Y1) {
        FW(lleg,       d - 1, FlyPos - 1, LIGHTRED);
        FW(spiderbody, d - 1, FlyPos,     LIGHTRED);
        FW(rleg,       d - 1, FlyPos + 1, LIGHTRED);
      }
      if(!Right) {
        FW(Flybody, d2, FlyPos,     YELLOW);
        FW(flywing, d2, FlyPos + 1, YELLOW);
      } else {
        FW(flywing, d2, FlyPos,     YELLOW);
        FW(Flybody, d2, FlyPos + 1, YELLOW);
      }
      Counter = 5;
      if(++d > d2)
        Counter = 6;
      break;

    case 6: // spider ascends
      Toggle = !Toggle;
      strcpy(character, (Toggle ? spider1 : spider2));
      *flywing = Toggle ? *Flywing1 : *Flywing2;
      if(d > (int) Y1) {
        FW(lleg,       d - 1, FlyPos - 1, LIGHTRED);
        FW(spiderbody, d - 1, FlyPos,     LIGHTRED);
        FW(rleg,       d - 1, FlyPos + 1, LIGHTRED);
      }
      FW(character, d, FlyPos - 1, LIGHTRED);
      if(d < (int) Y2) {
        FW(Space,   d + 1, FlyPos - 1, BLACK);
        FW(flywing, d + 1, FlyPos,     YELLOW);
        FW(Space,   d + 1, FlyPos + 1, BLACK);
      }
      if(d < Y2 - 1)
        FW("   ", d + 2, FlyPos - 1, BLACK);
      Counter = 6;
      if(--d <= Y1 - 1)
        Counter = 7;   // was -1 and counter 5
      break;

    case 7: // we clean up after the mess he made
      if(d > Y1 - 2) {
        FW(Space,   d + 1, FlyPos - 1, BLACK);
        FW(flywing, d + 1, FlyPos,     YELLOW);
        FW(Space,   d + 1, FlyPos + 1, BLACK);
      }
      FW("   ", d + 2, FlyPos - 1, BLACK);
      Counter = (--d > Y1 - 3) ? 7 : 0;
      break;
  }
  textattr(SaveTextAttr);
}

static void interrupt _far ScreenSaver()
{
  _enable(); // enable the interrupt system
  if(SSinUse)
    goto SkipThisCall;

  SSinUse = TRUE;

  switch(SSType) {
    case Confetti:
      LowLevelScreenSaver1();
      break;

    case Rockets:
      LowLevelScreenSaver2();
      break;

    case Spiders:
      LowLevelScreenSaver3();
      break;
  }

  SSinUse = FALSE;   // clear to enable further entries here

SkipThisCall:
  SaveVector = (ISR) ChainISRAddress(ISRHandle);
  (*SaveVector)(); // chain to the regular timer tick interrupt
}

void SetScreenSaverOn(void)
{
  int SaveDbaseOrder;

  if (!CheckRegisteredUnits("SetScreenSaverOn",REGTZCOMMON+REGTZVIDPOP+REGTZSAYGET+REGTZSAVER))
    return;
  if(ScreenSaverOn)
    return;
  Counter = 0;

  SSinUse = FALSE;
  ISRHandle = AddISRVector(ScreenSaver);
  if((X1 == 1) && (Y1 == 1) && (X2 == 80) && (Y2 == MaxAvailRows())) {
    WasVisible = CursorVisible();
    SetCursorOff();
  }
  ScreenSaverOn = TRUE;
  PushColors();
  SetColorTo(LIGHTGRAY, BLACK, LIGHTGRAY, BLACK);
  SaveDbaseOrder = dBASEOrder;
  dBASEOrder = FALSE;
  if(!SSLineStyle)
    Box(X1, Y1, X2, Y2, SSLineStyle, SSHeader);
  else
    Box(X1 - 1, Y1 - 1, X2 + 1, Y2 + 1, SSLineStyle, SSHeader);
  dBASEOrder = SaveDbaseOrder;
  PopColors();
}

void SetScreenSaverOff(void)
{
  if(!ScreenSaverOn)
    return;
  while(SSinUse);
  ScreenSaverOn = FALSE;
  RemoveISRVector(ISRHandle);
  SSinUse = FALSE;
  if((X1 == 1) && (Y1 == 1) && (X2 == 80) && (Y2 == MaxAvailRows()))
    if(WasVisible)
      SetCursorOn();
}

void SetSSWindowTo(unsigned char c1, unsigned char r1, unsigned char c2,
                   unsigned char r2, unsigned char LineStyle, char *Header)
{
  uchar Margin;

  if(ScreenSaverOn)
    return;
  if((LineStyle & 0x3F) > 5)
    SSLineStyle = LineStyle & 0xC0;
  else
    SSLineStyle = LineStyle;
  strcpy(SSHeader, Header);
  if((LineStyle & 0x3F) == NoLine)
    Margin = 0;
  else
    Margin = 1;
  if(dBASEOrder) {
    Convert((int *) &c1, (int *) &r1);
    Convert((int *) &c2, (int *) &r2);
  }
  // screen savers must fit into windows 5x5 or larger:
  if(((c2 - c1) < 4) || ((r2 - r1) < 4))
    SetError(220, 1, less_than_5x5);
  X1 = c1 + Margin;
  Y1 = r1 + Margin;
  X2 = c2 - Margin;
  Y2 = r2 - Margin;
  if ((X1 < 1) || (X1 > 80))
    X1 = 1;
  if((Y1 < 1) || (Y1 > MaxAvailRows()))
    Y1 = 1;
  if((X2 < 1) || (X2 > 80))
    X2 = 80;
  if((Y2 < 1) || (Y2 > MaxAvailRows()))
    Y2 = MaxAvailRows();
  Counter = 0;
}

void SetSSTypeTo(unsigned char Sometype)
{
  SSType = (Sometype > 2) ? 0 : Sometype;
}

void TZSaverInit(void)
{
  atexit(SetScreenSaverOff);
}
