/* filename: PRNHDING.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <setjmp.h>
#include <sayget.h>
#include <tzprint.h>
#include <timedate.h>
#include <utils.h>
#include <dbf.h>
#include <report.h>
#ifdef _MSC_VER
#include <dos.h>
#include <graph.h>
#endif

extern char *blankLine;
extern int  PageLength;
extern int  Continuous;
extern int  LineNumberCounter;
extern jmp_buf ReportJmp;

ReportTemplateType *RepTempl = NULL;
char  *LM;
char  *UserHeading;
unsigned int PageNumber  = 1;
int   LineNumber  = 1;
int   ConnectFlag = 0; // used to attach a report to the end of the previous report

void PrintHeading(void);

void WriteToAltNoConsole(char *str)
{
  int saveConsole;

  saveConsole = ConsoleOn;
  ConsoleOn = 0;
  WriteToAlt(str);
  ConsoleOn = saveConsole;
}

void ShiftLineNumber(int number)
{
  char waitflag = 0;
#ifdef _MSC_VER
  union _REGS regs;
#endif

  if (number) {
    if (number != PageLength) {
      if (LineNumberCounter) {
        WriteToAlt("\n");
#ifdef _MSC_VER
        if (ConsoleOn) {
          regs.h.ah = 0x0f; // get video page
          _int86(0x10, &regs, &regs);
          regs.h.ah = 3;    // get cursor position
          _int86(0x10, &regs, &regs);
          _settextposition(++regs.h.dh, ++regs.h.dl);
          _outtext(blankLine);
        }
#else
        if (ConsoleOn)
          cputs(blankLine);
#endif
        LineNumber++;
      }
      ++LineNumberCounter;
    }
    if (!Continuous)
      if ((LineNumber > PageLength) || number == PageLength) {
        ++PageNumber;
        LineNumber = 1;
        if (ConsoleOn) {
          if (!PrintOn && !AlternateOn) {
            putchar('\n');
            WaitTo(ReportPressAnyKey, &waitflag );
            if (waitflag == 0x1B)
              longjmp(ReportJmp, 1);
            gotoxy(1,1);
          }
        }
        ShiftLineNumber(0);
        PrintHeading();
      }
  }
  else // zero means FormFeed
    WriteToAltNoConsole("\f");
}

static void ChewingSemicolons(char *Temp)
{
  char c, *ptr, buf[STRSIZ];

  while (((ptr = strchr(Temp,';')) != NULL) && strcmp(Temp,";")) {
    c = *ptr;
    *ptr = 0;
    memset(buf, ' ', STRSIZ);
    strcpy(Temp, Trim(Temp));
    strcpy((char*) &buf+ (RepTempl->PageWidth-RepTempl->LeftMargin-RepTempl->RightMargin-strlen(Temp))/2, Temp);
    WriteToAlt("%s%s", LM, buf);
    ShiftLineNumber(1);
    *ptr = c;
    Delete(Temp, 0, PosOf(1,";",Temp)+1);
  }
}

void PrintHeading(void)
{
  int   i, j;
  char  HeadingString[3][STRSIZ]; // 3 heading lines, that's it
  char  Temp[STRSIZ], Sp[STRSIZ];
  char  UnderlineString[STRSIZ], *sc_ptr;
  int   Underlined;
  int   HeadString;
  int   origlineno;
  ReportColumnType *rc;

  origlineno = LineNumber;
  for (i = 0; i < (int)RepTempl->TopMargin; i++)
    ShiftLineNumber(1);
  strcpy(LM,Space(RepTempl->LeftMargin));
  if (!RepTempl->PlainPage)
    if (!ConnectFlag || (ConnectFlag && (origlineno == 1))) {
      WriteToAlt("%s%s%u", LM, PageNo, PageNumber);
      ShiftLineNumber(1);
      WriteToAlt("%s%s %s", LM, SystemDate(), SystemTime());
      ShiftLineNumber(1);
      ShiftLineNumber(1);
    }
  WriteToAltNoConsole(PrinterCode(RepTempl->PreTitlePrinterCode));
  if (*UserHeading) {
    strcpy(Temp,Trim(UserHeading));
    // deal with the issue of semicolons in the Users Heading
    if (Temp[strlen(Temp)-1] != ';')
      strcat(Temp, ";");
    ChewingSemicolons(Temp);
  }
  strcpy(Temp,Trim(RepTempl->Title));
  if (Temp[strlen(Temp)-1] != ';')
    strcat(Temp, ";");
  ChewingSemicolons(Temp);
  // if the user wants a dynamic page heading, get it now
  if (PageHeadingPtr && !dEOF()) { // position the file one down except on the first page
    if (PageNumber > 1)
      Skip(1);
    strcpy(Temp,PageHeadingPtr());
    if (PageNumber > 1)
      Skip(-1);
    if (Temp[strlen(Temp)] != ';')
      strcat(Temp, ";");
    ChewingSemicolons(Temp);
  }
  WriteToAltNoConsole(PrinterCode(RepTempl->PostTitlePrinterCode));
  if (Trim(RepTempl->PreTitlePrinterCode)[0] ||
      Trim(RepTempl->Title)[0] || Trim(RepTempl->PostTitlePrinterCode)[0])
    ShiftLineNumber(1);
  for (i = 0; i < 3; i++)
    strcpy(HeadingString[i], Space(RepTempl->LeftMargin+2)); // 2 spaces reserved for deleted record indicator
  strcpy(UnderlineString, Space(RepTempl->LeftMargin+2));
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
    rc = RepTempl->FieldMap[i];
    strcpy(Sp, Space(rc->Tab));
    // this deals with the semicolons in the field headings
    strcpy(Temp, rc->Heading);
    for (j = 0; j < 3; j++) {
      strcat(HeadingString[j], PrinterCode(rc->PrePrinterCode));
      // given a field heading, width and a "semicolon count", this code
      // returns either the heading or spaces (either way, padded with spaces
      // to the correct width) appropriate for the string ahead of the desired
      // semicolon
      sc_ptr = strchr(Temp, ';');
      if (sc_ptr)
        *sc_ptr = 0;
      strcat(HeadingString[j], Pad(Temp,rc->Width));
      if (sc_ptr)
        strcpy(Temp, ++sc_ptr);
      else
        *Temp = 0;
      strcat(HeadingString[j], Sp);
      strcat(HeadingString[j], PrinterCode(rc->PostPrinterCode));
    }
    strcat(UnderlineString, Replicate(RepTempl->UnderlineChar,rc->Width));
    strcat(UnderlineString, Sp);
  }
  HeadString = FALSE;
  Underlined = FALSE;
  for (i = 0; i < 3; i++)
    if (Trim(HeadingString[i])[0]) {
      WriteToAlt(HeadingString[i]);
      ShiftLineNumber(1);
      HeadString = TRUE;
    }
    else { // empty header string, check for underlining
      if ((!Underlined) && Trim(UnderlineString)[0]) {
        WriteToAlt(UnderlineString);
        ShiftLineNumber(1);
      }
      Underlined = TRUE;
    }
  if (!Underlined && Trim(UnderlineString)[0]) {
    WriteToAlt(UnderlineString);
    ShiftLineNumber(1);
  }
  if (HeadString)
    ShiftLineNumber(1);
}
