/* filename: VIEWQUE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <string.h>
#include <pick.h>
#include <dialog.h>
#include <utils.h>
#include <sayget.h>
#include <printcom.h>

void ResumePrintJobs(void);
void HoldPrintJobs(void);

static char *ItemMaker(int i) //  used by tag list
{
  return PrintQueueItem(i);
}

void ViewQueue(void)
//  Tag files to be removed from the print queue. When a print job is
//  canceled its name is removed from the list and all the filenames below it
//  in the list are moved up.  This means that we cannot reference the name
//  of the next tagged file by its old position in the list.  Thus we keep a
//  seperate list of tagged file names from which to call CancelSpoolFile.
//  We have to have a dynamic list since it is not possible to know at
//  compile time how many files might be in the Print.com file list.
{
  int            i, Count, CurrentItem, Error;
  long           ItemsToRemove;
  PickWindowType SaveTagWindow;
  SpoolFilename *TaggedFileList;

  if(DosSpoolerInstalled) {
    HoldPrintJobs();

    if((Count = PrintQueueCount()) > MaxQueueFiles)
      Count = MaxQueueFiles;

    if(Count) {
      i = Count * sizeof(SpoolFilename);
      if((TaggedFileList = malloc(i)) != NULL) {
        memset(TaggedFileList, 0, i);

        memcpy(&SaveTagWindow, TagSpecPtr, sizeof(SaveTagWindow));
        SetTagWindowTo(10, 10, 70, 20, 1, "Mark files to remove file(s) from print queue");
        ItemsToRemove = TagItems(ItemMaker, 1, Count, 1);
        memcpy(TagSpecPtr, &SaveTagWindow, sizeof(SaveTagWindow));

        if(ItemsToRemove) { // fill the dynamic array with tagged filenames:
          for(i = 0; i < ItemsToRemove; i++) { // ItemsToRemove can't be larger than Count
            CurrentItem = (int) TaggedItem();
            if(i < MaxQueueFiles)
              strcpy((char *) (TaggedFileList+i), ItemMaker(CurrentItem));
          }

          for(i = 0; i < ItemsToRemove; i++) // cancel the files in the list:
            if(i < MaxQueueFiles) {
              Error = CancelSpoolFile((char *)(TaggedFileList+i));
              if(Error)
                DialogBox(BuildStr("'", TaggedFileList+i ,"'", Cannot_be_cancelled_Error,
                                   SInteger(Error, 0), NULL), ScrollPressAnyKey);
            }
        }
        free(TaggedFileList);
      } else
        DialogBox(Insufficient_memory_to_cancel_print_jobs, ScrollPressAnyKey);
    } else
      DialogBox(DOS_print_queue_is_empty, ScrollPressAnyKey);
    ResumePrintJobs();
  } else
    DialogBox(DOS_print_spooler_is_not_installed, ScrollPressAnyKey);
}
