/* filename: TAGITEMS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
#include <sayget.h>
#include <dbf.h>
#include <pick.h>

#define TAGME   1
#define PICKME  2

extern int FirstItem;
extern int StartingItem;
extern int MaxItem;
extern int MaxVisibleItems;
extern int MinItem;
extern int NumberTagged;
extern int TagOrderOn;
extern int IndexedFile;
extern int CurrentItem;
extern PickWindowPtr CurrentWindow;
extern unsigned char PickMode; // 1 - absolute, 0 - relative

void DrawBox(void);
void FillBox(void);
void PaintBar(void);
void GoToTopItem(void);
void GoToBottomItem(void);
void GoToPriorItem(void);
void GoToNextItem(void);
void JumpTo(unsigned char VisibleItem);
int  wmPickNo(void); // returns (IndexedFile ? RecNo() : ItemNo)
char wmKey(unsigned char * VisibleItem);
void wmHuntItem(char KeyStroke);
void PaintArrows(void);
char * UsersString(int i);
int IsTagged(long i);
void UnTagCurrentItem(void);

extern char * (* StringMakerPtr)(int);

extern unsigned char Pick_sf, Pick_sb, Pick_gf, Pick_gb;  // "say" and "get" colors used when painting
extern ItemPtrType ItemHead;
extern int ItemNo;
extern int Tagging;
extern PickWindowType _tzfar TagWindow, _tzfar PickWindow;
extern ItemPtrType LastItemNextPtr;
extern void * Head;
extern LinkPtrType FileNamePtr;
extern ItemPtrType ItemNumberPtr;

int PreTagSet = FALSE;
int PickOlddBASEOrder; // TRUE if already using dBASE coordinates

void ReleaseMemory(void)
{
  LinkPtrType temp1;
  ItemPtrType temp2;

  if (Head) { // freemem all the void *s
    FileNamePtr = Head;
    do {
      temp1 = FileNamePtr;
      free(FileNamePtr);
      FileNamePtr = temp1->NextPtr;
    }  while (FileNamePtr);
    Head = NULL;
  }
  if (ItemHead) { // do the same thing for the item list
    ItemNumberPtr = ItemHead;
    do {
      temp2 = ItemNumberPtr;
      free(ItemNumberPtr);
      ItemNumberPtr = temp2->NextPtr;
    }  while (ItemNumberPtr);
    ItemHead = NULL;
    LastItemNextPtr = NULL;
    PreTagSet = FALSE;
  }
  NumberTagged = 0;
}

static void ReOrderTags(void) // do a bubble sort on the linked list
{
  int NothingSwapped;
  int Count;
  long temp;
  int i;

  if (!ItemHead)
    return; // no items to sort
  if (ItemHead->NextPtr == NULL)
    return; // one item, no need to sort
  // at this point we will have two or more items..so sort
  ItemNumberPtr = ItemHead;
  // get the number of items in the list
  for (Count = 0; ItemNumberPtr->NextPtr != NULL; ++Count)
    ItemNumberPtr = ItemNumberPtr->NextPtr;
  do {
    NothingSwapped = TRUE;
    ItemNumberPtr = ItemHead;
    for (i = 0; i < Count; i++) { // swap data
      if (ItemNumberPtr->SortNumber > ItemNumberPtr->NextPtr->SortNumber) {
        temp = ItemNumberPtr->ItemNumber;
        ItemNumberPtr->ItemNumber = ItemNumberPtr->NextPtr->ItemNumber;
        ItemNumberPtr->NextPtr->ItemNumber = temp;
        temp = ItemNumberPtr->SortNumber;
        ItemNumberPtr->SortNumber = ItemNumberPtr->NextPtr->SortNumber;
        ItemNumberPtr->NextPtr->SortNumber = temp;
        NothingSwapped = FALSE;
      }
      ItemNumberPtr = ItemNumberPtr->NextPtr;
    }
    --Count;
  }  while (!NothingSwapped);
}

static void PaintTagSymbol(void)
{
  unsigned char x, y;

  x = (unsigned char) (TagWindow.r1+ItemNo-FirstItem+1);
  y = (unsigned char) (TagWindow.c1+1);
  At(x, y, "\x10");
  Paint(x, y, 1, (unsigned char) (SelectedColor & 0x0F), Pick_sb);
}

static void TagCurrentItem(void) // add a new link to the end of the list
{
  if ((ItemNumberPtr = malloc(sizeof(*ItemNumberPtr))) == NULL) {
    SetError(217, 1, "[TagItems]");
    return;
  }
  if (!ItemHead) // go to the last in the list
    ItemHead = ItemNumberPtr;
  ItemNumberPtr->SortNumber = ItemNo;
  ItemNumberPtr->ItemNumber = wmPickNo();
  ItemNumberPtr->PrevPtr = LastItemNextPtr;
  if (LastItemNextPtr)
    LastItemNextPtr->NextPtr = ItemNumberPtr;
  ItemNumberPtr->NextPtr = NULL;
  LastItemNextPtr = ItemNumberPtr;
  PaintTagSymbol();
  ++NumberTagged;
}

static void ToggleItem(int MouseEvent)
{
  long TargetItem;

  TargetItem = wmPickNo();
  if (IsTagged(TargetItem))
    UnTagCurrentItem();
  else
    TagCurrentItem();
  if (!MouseEvent)
    GoToNextItem();
}

long wmMakeChoice(char *(*_StringMakerPtr)(int), long _MinItem, long _MaxItem,
                  long _StartingItem, int Pick_Tag)
{
  char KeyStroke;
  int i;
  long temp;
  WindowRec SaveWindow;
  unsigned oldcursor;
  char SideWaysKeys[20] = { "\r\x1B" };
  unsigned char VisibleItem;
#ifndef _MSC_VER
  unsigned char SaveX, SaveY;
  struct text_info ti;
#else
  struct _rccoord tp;
  short left, top, right, bottom;
#endif
  int ret;

  if (!CheckRegisteredUnits("Pick", REGTZCOMMON+REGTZDBF+REGTZVIDPOP+REGTZSAYGET+REGTZPICK))
    return 0L;
  CurrentWindow = (Pick_Tag == TAGME) ? &TagWindow : &PickWindow;
#ifdef _MSC_VER
  tp = _gettextposition();
#else
  SaveX = wherex();
  SaveY = wherey();
#endif
  PickOlddBASEOrder = dBASEOrder;
  dBASEOrder = TRUE;
  PushColors();
  SetColorTo(CurrentWindow->fg,CurrentWindow->bg,
  CurrentWindow->barFG,CurrentWindow->barBG);
  CurrentColors(&Pick_sf, &Pick_sb, &Pick_gf, &Pick_gb);
  if ((Pick_gf == Pick_sf) && (Pick_gb == Pick_sb)) {
    Pick_gb = Pick_sf;
    Pick_gf = Pick_sb;
  }
  if (!SelectedColor && (Pick_Tag == TAGME))
    SetHighlightTo(Pick_sf,Pick_sb);
#ifdef _MSC_VER
  _gettextwindow(&top, &left, &bottom, &right);
  _settextwindow(1, 1, MaxAvailRows(), 80);
#else
  gettextinfo(&ti);
  window(1, 1, 80, MaxAvailRows());
#endif
  StringMakerPtr = _StringMakerPtr;
  PickMode = _StartingItem ? 1 : 0;
  MaxItem = (int) _MaxItem;
  MinItem = (int) _MinItem;
  if (MinItem > MaxItem) { // user specified things in the wrong order, swap them
    temp = MinItem;
    MinItem = MaxItem;
    MaxItem = (int) temp;
  }
  StartingItem = (int) _StartingItem;
  if (StartingItem) {
    if (StartingItem < MinItem)
      StartingItem = MinItem;
    if (StartingItem > MaxItem)
      StartingItem = MaxItem;
    IndexedFile = FALSE;
  }
  else // "0" is special..means user is working with an indexed file
    IndexedFile = TRUE;
  CurrentItem = StartingItem;
  // save the area under the TagItems; c1+1 because this is dbase coordinates
  i = CurrentWindow->linestyle & Shadow;
  FillWindow((unsigned char) (CurrentWindow->c1+1),
  (unsigned char) (CurrentWindow->r1+1),
  (unsigned char) (CurrentWindow->c2+(i ? 4 : 1)),
  (unsigned char) (CurrentWindow->R2+(i ? 2 : 1)), &SaveWindow);
  if (SaveWindow.BufferPtr == NULL) {
    if (Pick_Tag == PICKME)
      ret = -3;
    goto BAILOUT;
  }
  // initialize linked list and release any memory from the last call
  if (Pick_Tag == TAGME) {
    if (ItemHead && !PreTagSet) {
      ReleaseMemory();
      LastItemNextPtr = NULL;
      ItemHead = NULL;
    }
    Tagging = TRUE;
  }
  DrawBox();
  FillBox();
  ItemNo = StartingItem;
  SaveCursor(&oldcursor);
  SetCursorOff();
  PaintBar();

  EnableMouse();
  if (EnableLeftRightExit)
    strcpy(SideWaysKeys+2, "\x13\x04");
  else
    SideWaysKeys[2] = 0;
  do {
    UsersString(ItemNo); // call the users function for each item
    PaintArrows();
    CurrentPickListItem =  wmPickNo();
    KeyStroke = wmKey(&VisibleItem);
    switch (KeyStroke) {
      case '\x05':
        GoToPriorItem();
        break;
      case '\x20':
        if (Pick_Tag == TAGME) {
          ToggleItem(FALSE);
          break;
        }
      case '\x18':
      case '\x09':
        GoToNextItem();
        break;
      case '\x12':
        for (i = 0; i < MaxVisibleItems; i++)
          GoToPriorItem();
        break;
      case '\x03':
        for (i = 0; i < MaxVisibleItems; i++)
          GoToNextItem();
        break;
      case '\x01':
        GoToTopItem();
        break;
      case '\xFD':
        if (Pick_Tag == TAGME)
          ToggleItem(TRUE); // undo effect of first half of double click
        KeyStroke = '\r';
        break;
      case '\xFE':
        JumpTo(VisibleItem);
        if (!IsLeftButtonDown() && (Pick_Tag == TAGME))
          ToggleItem(TRUE);
        break;
      case '\xFF':
        GoToBottomItem();
        break;
    }
    // search for the item with an initial letter matching the key pressed
    wmHuntItem(KeyStroke);
  }  while (!(strchr(SideWaysKeys, KeyStroke) && KeyStroke));
  DisableMouse();
  PopMouse();

  if (Pick_Tag == TAGME) {
    if (KeyStroke == '\x1B')
      ReleaseMemory();
    // If there are no items tagged, and you press Enter, then treat
    // this as a picklist, i.e., tag that one item and exit:
    if ((KeyStroke == '\r') && !NumberTagged)
      ToggleItem(FALSE);
    ret = NumberTagged;
    if (!TagOrderOn) // if programmer wants items in display order...
      ReOrderTags();
  }
  else {
    switch (KeyStroke) {
      case '\r': ret = wmPickNo(); break;
      case '\x1B': ret = 0;  break;
      case '\x13': ret = -1; break; // left arrow
      case '\x04': ret = -2; break; // right arrow
    }
  }
  if ((Pick_Tag == TAGME) || PickSaveWindow)
    DisplayWindow(&SaveWindow);
  BAILOUT:
  RestoreCursor(oldcursor);
  dBASEOrder = PickOlddBASEOrder; // restore users coordinate system
#ifdef _MSC_VER
  _settextwindow(top, left, bottom, right);
  _settextposition(tp.row, tp.col);
#else
  window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
  gotoxy(SaveX,SaveY);
#endif
  PopColors();
  return ret;
}

int TagItems(char * (*StringMaker)(int), long minItem, long maxItem, long startItem)
{
  return (int) wmMakeChoice(StringMaker, minItem, maxItem, startItem, TAGME);
}

void SetTag(int i)
{
  if (ItemHead && (!PreTagSet)) {
    ReleaseMemory();
    LastItemNextPtr = NULL;
    ItemHead = NULL;
  }

  ItemNumberPtr = (ItemPtrType) malloc(sizeof(ItemNumberRec));
  if (!ItemNumberPtr) {
    SetError(InsufficientMemory, 1, " [SetTag]");
    return;
  }
  // go to the last in the list
  if (!ItemHead)
    ItemHead = ItemNumberPtr;

  ItemNumberPtr->SortNumber = i;
  ItemNumberPtr->ItemNumber = i;
  ItemNumberPtr->PrevPtr = LastItemNextPtr;
  if (LastItemNextPtr)
    LastItemNextPtr->NextPtr = ItemNumberPtr;
  ItemNumberPtr->NextPtr = NULL;
  LastItemNextPtr = ItemNumberPtr;

  ++NumberTagged;
  PreTagSet = TRUE;
}
