/* filename: TAGDFILS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <sayget.h>
#include <dbf.h>
#include <pick.h>

#define FILL_LL  1
#define ADDTO_LL 2

extern unsigned char TagAttr;
extern PathStr _tzfar TagPath;
extern PickWindowType _tzfar TagWindow;
extern void * Head;
extern LinkPtrType FileNamePtr;
extern ItemPtrType ItemNumberPtr;
extern PathStr _tzfar SeedFilename;
extern int SeedNumber;
extern int MaxNames;
extern int NormalFiles;
extern int NoExtension;
extern int ShowDateAndSize;
extern PickWindowPtr CurrentWindow;
extern PickWindowType TagWindow;

void ReleaseMemory(void);
char * FileNameList(int  i);
void FillLinkedList(char * path, char * mask, unsigned char Attr);
void AddToLinkedList(char * path, char * mask, unsigned char Attr);
unsigned char ParseListName(char *NewMask, char *temp, char *Extension);
void ProcessLList(char * path, char * mask, unsigned char Attr, int command);
void SortLinkedList(void);

int TagFiles(char * mask)
{
  char NewMask[STRSIZ], Extension[20];
  char tmp[STRSIZ];
  // used for resizing the window to fit number of files
  unsigned char PriorR2;
  // used for resizing the window to file the filename width
  unsigned char PriorC2;
  WindowRec SaveWindow;
  PickWindowType OldTagWindow;
  EventRec e;
  int ret;

  if (!CheckRegisteredUnits("TagFiles", REGTZCOMMON+REGTZDBF+REGTZVIDPOP+REGTZSAYGET+REGTZPICK))
    return 0;
  strcpy(tmp, mask);
  memmove(&OldTagWindow, &TagWindow, sizeof(PickWindowType));
  CurrentWindow = &TagWindow;

  TagAttr = ParseListName(NewMask, tmp, Extension);
  // strip off the Tagpath, if any
  if (strchr(NewMask, '\\')) { // get the Tagpath
    strcpy(TagPath , NewMask);
    * (strrchr(TagPath , '\\') + 1) = 0;
    strcpy(NewMask, strrchr(NewMask, '\\') + 1);
  }
  else
    TagPath[0] = 0;

  if (Head)
    ReleaseMemory();
  ProcessLList(TagPath, NewMask, TagAttr, FILL_LL);
  if (strstr(tmp, "ADDDIRECTORIES"))
    ProcessLList(TagPath, "*.*", FA_DIREC, ADDTO_LL);
  SortLinkedList();
  FileNamePtr = Head;

  // auto-size the Tag window if possible
  //first, the number of rows:
  PriorR2 = TagWindow.R2;
  if ((TagWindow.R2 - TagWindow.r1 > MaxNames) && MaxNames)
    TagWindow.R2 = MaxNames + TagWindow.r1 + 1;

  // next, the number of columns
  PriorC2 = TagWindow.c2;
  if (NoExtension && (strstr((char *) tmp, (char *) "ADDDIRECTORIES") == NULL))
    TagWindow.c2 = TagWindow.c1 + 12;
  else
    TagWindow.c2 = TagWindow.c1 + 18;  //  '  [director.dir] ' 18 chars wide
  if (ShowDateAndSize)
    TagWindow.c2 += (CenturyOn ? 28 : 26);
  TagWindow.BarWidth = TagWindow.c2 - TagWindow.c1-1;

  // what if the header doesn't fit? let's check: *
  // use the originally specified value of C2, if larger than the new C2
  if (TagWindow.BarWidth < strlen((char far *) TagWindow.Header)) {
    if (PriorC2 > TagWindow.c2)
      TagWindow.c2 = PriorC2;
    TagWindow.BarWidth = TagWindow.c2 - TagWindow.c1-1;
  }

  if (FileNamePtr == NULL) {
    memset(&TagFileResult, 0, sizeof(TagFileResult));
    // C1 + 1 because this is dbase coordinates
    if (TagWindow.linestyle & Shadow)
      FillWindow((unsigned char) (TagWindow.c1 + 1),
      (unsigned char) (TagWindow.r1 + 1),
      (unsigned char) (TagWindow.c2 + 1 + 3),
      (unsigned char) (TagWindow.R2 + 1 + 1), &SaveWindow);
    else
      FillWindow((unsigned char) (TagWindow.c1 + 1),
      (unsigned char) (TagWindow.r1 + 1),
      (unsigned char) (TagWindow.c2 + 1),
      (unsigned char) (TagWindow.R2 + 1), &SaveWindow);
    if (dBASEOrder) {
      Box(TagWindow.r1, TagWindow.c1, TagWindow.r1 + 2,
      TagWindow.c2, TagWindow.linestyle, press_esc);
      At(TagWindow.r1 + 1,TagWindow.c1 + 1, no_files);
    }
    else {
      Box(TagWindow.c1 + 1,TagWindow.r1 + 1,TagWindow.c2 + 1,
      TagWindow.r1 + 3,TagWindow.linestyle, press_esc);
      At(TagWindow.c1 + 2,TagWindow.r1 + 2, no_files);
    }
    PushMouse();
    // repeat dummy := ReadKey until dummy = #27; old mouseless way
    AddTarget(1, 1, 80, MaxAvailRows(),ReservedID,RightButtonReleased);
    EnableMouse();
    do {
      GetEvent(&e);
    }  while (!(((e.WhichEvent == Mouse) && (e.v.sMouse.TargetID == ReservedID)) ||
    ((e.WhichEvent == Keyboard) && (e.v.sKeyboard.Key == '\x1B'))));
    DisableMouse();
    PopMouse();
    if (SaveWindow.BufferPtr != NULL)
      DisplayWindow(&SaveWindow);
    ret =  0;
  }
  else
    ret = TagItems(FileNameList,1,MaxNames,SeedNumber);

  TagWindow.R2 = PriorR2; // restore Tag corner
  TagWindow.c2 = PriorC2;
  memmove((void *) &TagWindow, (void *) &OldTagWindow, sizeof(PickWindowType));
  return ret;
}
