/* filename: PICKFILE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _MSC_VER
#include <direct.h>
#include <malloc.h>
#include <graph.h>
#else
#include <dir.h>
#include <alloc.h>
#endif
#include <sayget.h>
#include <pick.h>

#define FILL_LL  1
#define ADDTO_LL 2

extern PathStr _tzfar SeedFilename,_tzfar PickPath;
extern int SeedNumber;
extern int MaxNames;
extern int NormalFiles;
extern unsigned char PickAttr;
extern int NoExtension;
extern int ShowDateAndSize;
extern int FirstItem;
extern int ItemNo;
extern int StartingItem;
extern int LastItem;
extern int MaxItem;
extern int MaxVisibleItems;
extern int MinItem;
extern int IndexedFile;
extern int CurrentItem;
extern PickWindowPtr CurrentWindow;
extern PickWindowType _tzfar PickWindow;
extern LinkPtrType FileNamePtr;
extern void * Head;
extern char * (* StringMakerPtr)(int);

void ProcessLList(char * path, char * mask, unsigned char Attr, int command);
void DrawBox(void);
void FillBox(void);
void UnPaintBar(void);
void PaintBar(void);
void GoToTopItem(void);
void GoToBottomItem(void);
char * FileNameList(int  i);
void GoToPriorItem(void);
void GoToNextItem(void);
void JumpTo(unsigned char VisibleItem);
void PaintArrows(void);
char * UsersString(int i);
void SortLinkedList(void);

static char _tzfar stbuf[80] = { "" };

static void RelMem(void)
{
  LinkPtrType temp;

  FileNamePtr = Head;
  while (FileNamePtr) { // free all the void *s
    temp = FileNamePtr;
    free(FileNamePtr);
    FileNamePtr = temp->NextPtr;
  } // now that we are done, set head back to NULL..future calls to tag will need this!
  Head = NULL;
}

unsigned char ParseListName(char *NewMask, char *temp, char *Extension)
{
  unsigned char attr = 0;
  char *ptr;

  NoExtension = FALSE;
  ShowDateAndSize = FALSE;
  // parse the mask
  strcpy(temp,Upper(Ltrim(Trim(temp)))); // trim and uppercase the mask
  attr = 0;
  strcpy(NewMask,temp);
  ptr = strchr(NewMask, ' ');
  if (ptr) { // is there more than a file spec?
    *ptr = 0; // NewMask is the filespec
    strcpy(temp, strchr(temp, ' ') + 1); // mask now contains the clauses
    if (strstr(temp, "NOEXTENSION")) { // look for the NOEXTENSION clause
      NoExtension = TRUE;
      strcpy(Extension, NewMask);
      strcpy(Extension, strrchr(Extension, '.'));
    }
    // locate READONLY, HIDDEN, DIRECTORY, SYSTEM, NORMAL, ARCHIVE clauses
    if (strstr(temp, "READONLY"))
      attr |= FA_RDONLY;
    if (strstr(temp, "HIDDEN"))
      attr |= FA_HIDDEN;
    if (strstr(temp, "DIRECTORY"))
      attr |= FA_DIREC;
    if (strstr(temp, "SYSTEM"))
      attr |= FA_SYSTEM;
    if (strstr(temp, "ANYFILE"))
      attr = FA_RDONLY | FA_HIDDEN | FA_DIREC | FA_SYSTEM;
    NormalFiles = (strstr(temp, "NORMAL") != NULL);
    ShowDateAndSize = (strstr(temp, "SIZE&DATE") != NULL);
    ptr = strstr(temp, "SEED=");
    if (ptr) {
      strcpy(SeedFilename, Ltrim(strcpy(temp, ptr + 5)));
      ptr = strchr(SeedFilename, ' ');
      if (ptr)
        strcpy(SeedFilename, ptr - 1);
    }
    else
      SeedFilename[0] = 0;
  }
  return attr;
}

char * PickFile(char * mask)
{
  long i;
  char NewMask[STRSIZ];
  char temp[STRSIZ], temp1[STRSIZ];
  char Extension[STRSIZ];
  unsigned char PriorR2; // for resizing the window to fit number of files
  unsigned char PriorC2; // for resizing the window to fit the filename width
  WindowRec SaveWindow;
  int IsDirectory, t, tt;
  PickWindowType OldPickWindow;
  DirStr Dir;
  NameStr Name;
  ExtStr Ext;
  DirStr CurrentDir;
  int GivenDir;
  EventRec e;
#ifndef _MSC_VER
  struct text_info ti;
#else
  short left, top, right, bottom;
#endif
  char buf[80];

  if (!CheckRegisteredUnits("PickFile", REGTZCOMMON+REGTZDBF+REGTZVIDPOP+REGTZSAYGET+REGTZPICK))
    return "";
  strcpy(temp, mask);
  memcpy(&OldPickWindow, &PickWindow, sizeof(PickWindowType));
  CurrentWindow = &PickWindow;
  PickAttr = ParseListName(NewMask, temp, Extension);
  // strip off the path, if any
  FSplit(NewMask,Dir,Name,Ext);
  GivenDir = (Dir[0] != 0);
  if(_fullpath(buf, NewMask, sizeof(buf)))
    strcpy(NewMask, buf);
  FSplit(NewMask,Dir,Name,Ext);
  strcpy(PickPath, Dir);
  getcwd(CurrentDir, sizeof(DirStr));
  if (strlen(CurrentDir) > 3)
    strcat(CurrentDir, "\\");
  if ((!strcmp(PickPath, CurrentDir)) && !GivenDir)
    PickPath[0] = 0;
  sprintf(NewMask,"%s%s", Name, Ext);
  ProcessLList(PickPath, NewMask, PickAttr, FILL_LL);
  if (strstr(temp, "ADDDIRECTORIES"))
    ProcessLList(PickPath, "*.*", FA_DIREC, ADDTO_LL);
  SortLinkedList();
  FileNamePtr = Head;

  // auto-size the pick window if possible. First, the number of rows:
  PriorR2 = PickWindow.R2;
  if ((PickWindow.R2 - PickWindow.r1 > MaxNames) && (MaxNames != 0))
    PickWindow.R2 = MaxNames + PickWindow.r1 + 1;
  // next, the number of columns
  PriorC2 = PickWindow.c2;
  PickWindow.c2 = PickWindow.c1 + 11 +  // ' [director.dir] ' width = 16
  ((NoExtension && !strstr(temp, "ADDDIRECTORIES")) ? 0 : 6);
  if (ShowDateAndSize)
    PickWindow.c2 += (CenturyOn ? 28 : 26);
  PickWindow.BarWidth = PickWindow.c2 - PickWindow.c1-1;
  // what if the header doesn't fit? let's check:
  // use the originally specified value of C2, if larger than the new C2
  if (PickWindow.BarWidth < strlen(PickWindow.Header)) {
    if (PriorC2 > PickWindow.c2)
      PickWindow.c2 = PriorC2;
    PickWindow.BarWidth = PickWindow.c2 - PickWindow.c1-1;
  }
  memset(&PickFileResult, 0, sizeof(PickFileResult));
  if (!FileNamePtr)  {
    i = 0;
    if (PickSaveWindow) {
      // C1 + 1 because this is dbase coordinates
      t = PickWindow.linestyle & Shadow;
      FillWindow((unsigned char)(PickWindow.c1+1),
      (unsigned char)(PickWindow.r1+1),
      (unsigned char)(PickWindow.c1+1+strlen(press_esc)+(t ? 4 : 2)),
      (unsigned char)(PickWindow.R2+(t ? 2 : 1)), &SaveWindow);
    }
    // fiddle with windows on account of the AT to follow
#ifdef _MSC_VER
    _gettextwindow(&top, &left, &bottom, &right);
    _settextwindow(1, 1, MaxAvailRows(), 80);
#else
    gettextinfo(&ti);
    window(1,1,80,MaxAvailRows());
#endif
    PushColors();
    SetColorTo(PickWindow.fg,PickWindow.bg,PickWindow.barFG,PickWindow.barBG);
    if (dBASEOrder) {
      Box(PickWindow.r1,PickWindow.c1,PickWindow.r1 + 2,PickWindow.c1 + strlen(press_esc) + 2,PickWindow.linestyle,press_esc);
      At(PickWindow.r1 + 1,PickWindow.c1 + 1,no_files);
    }
    else {
      Box(PickWindow.c1 + 1,PickWindow.r1 + 1,PickWindow.c1 + 1 + strlen(press_esc) + 2,PickWindow.r1 + 3,PickWindow.linestyle,press_esc);
      At(PickWindow.c1 + 2,PickWindow.r1 + 2, no_files);
    }
#ifdef _MSC_VER
    _settextwindow(top, left, bottom, right);
#else
    window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
#endif
    PopColors();
    PushMouse();
    // repeat dummy := ReadKey until dummy = #27; old mouseless way
    AddTarget(1,1,80,MaxAvailRows(),ReservedID,RightButtonReleased);
    EnableMouse();
    do {
      GetEvent(&e);
    }  while (!(((e.WhichEvent == Mouse) && (e.v.sMouse.TargetID == ReservedID)) ||
    ((e.WhichEvent == Keyboard) && (e.v.sKeyboard.Key == '\x1B'))));
    DisableMouse();
    PopMouse();
    if (SaveWindow.BufferPtr)
      if (PickSaveWindow)
        DisplayWindow(&SaveWindow);
  }
  else
    i = PickList(FileNameList,1,MaxNames,SeedNumber);
  
  PickWindow.R2 = PriorR2; // restore pick corner
  PickWindow.c2 = PriorC2;
  ShowDateAndSize = FALSE;
  if (i > 0) {
    strcpy(temp, Ltrim(Trim(FileNameList((int) i))));
    if (temp[0] == '[') { // remove the [] characters
      IsDirectory = TRUE;
      strcpy(temp, temp+1);
      temp[strlen(temp)-1] = 0;
    }
    else {
      IsDirectory = FALSE;
      if (NoExtension)
        strcat(temp, Upper(Extension));
    }
    // if FullName then
    sprintf(temp1,"%s%s", (char _far *)PickPath, temp);// PickFile returns simple file name unless FULLNAME clause is present
    strcpy(temp, temp1);
    for (t=tt=0; tt < (int) strlen(temp); ++tt) {// remove any spaces in the result
      if(temp[tt] != ' ')
        temp[t++] = temp[tt];
    }
    temp[t] = 0;
    if (temp[0] == '\x01')
      strcpy(temp, temp+1);
    if (IsDirectory) {
      PickFileResult.attrib = FA_DIREC;
      strcpy(PickFileResult.name, temp);
    }
    else
#ifdef _MSC_VER
      _dos_findfirst(temp, (unsigned) PickAttr, &PickFileResult);
#else
    findfirst(temp, (struct ffblk *) &PickFileResult, PickAttr);
#endif
  }
  else
    temp[0] = 0;
  RelMem();
  memcpy(&PickWindow, &OldPickWindow, sizeof(PickWindowType));
  strcpy(stbuf, temp);
  return stbuf;
}
  
