/* filename: LLSTFUNC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#ifdef _MSC_VER
#include <direct.h>
#else
#include <dir.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
#include <dbf.h>
#include <pick.h>
  
extern LinkPtrType FileNamePtr;
extern PathStr _tzfar SeedFilename;
extern int SeedNumber;
extern int NormalFiles;
extern PickWindowPtr CurrentWindow;
extern PickWindowType _tzfar TagWindow ;
extern int MaxNames;
extern void * Head;
extern LinkPtrType LastNextPtr;
  
int AppendItem(LinkPtrType  FilenamePtr, struct find_t *s);
  
#define FILL_LL  1
#define ADDTO_LL 2
  
void ProcessLList(char * path, char * mask, unsigned char Attr, int command)
{
  struct find_t S;
  char fname[80];
  
  if (command == FILL_LL) {
    MaxNames = 0;
    LastNextPtr = NULL;
    Head = NULL;
  }
  sprintf(fname, "%s%s", path, mask);
  errno = 0; // clear errno from previous faults
#ifdef _MSC_VER
  _dos_findfirst(fname, (unsigned) Attr, &S);
#else
  findfirst(fname,  (struct ffblk *) &S, (int) Attr);
#endif
  while (errno == 0) {
    S.attrib &= 0x1F; // ignore bits 5, 6, 7
    if (strcmp(S.name,".") != 0) {
      if (  ((Attr == 0) && (S.attrib == 0))  ||
        ((Attr > 0) && (S.attrib & Attr)) ||
      (NormalFiles && (S.attrib == 0))) { // collect files that ONLY match desired attributes
        if (!AppendItem(FileNamePtr, &S))
          return;
      }
    }
#ifdef _MSC_VER
    _dos_findnext(&S);
#else
    findnext((struct ffblk*) &S);
#endif
    AdvanceRotor(); // show a rotor..handy for big directories
  }
}
  
void SortLinkedList(void)
{
  int i, j;
  char temp[16];
  char tempdate[31];
  
  if (MaxNames == 0)
    return; // exit if no files matched the mask
  j = MaxNames - 1;
  // do a bubble sort, go down the linked list and compare pairs of names,
  // swap names if need be
  for (j = MaxNames - 1; j >= 1; j--) {
    FileNamePtr = Head;
    for (i = 1; i <= j; i++) {
      if (strcmp(FileNamePtr->Name,FileNamePtr->NextPtr->Name) > 0) {
        strcpy(temp,FileNamePtr->Name);
        strcpy(tempdate,FileNamePtr->DateTimeSize);
        strcpy(FileNamePtr->Name,FileNamePtr->NextPtr->Name);
        strcpy(FileNamePtr->NextPtr->Name,temp);
        strcpy(FileNamePtr->DateTimeSize,FileNamePtr->NextPtr->DateTimeSize);
        strcpy(FileNamePtr->NextPtr->DateTimeSize,tempdate);
      }
      FileNamePtr = FileNamePtr->NextPtr;
    }
  }
  SeedNumber = 1;
  // if a seed was specified, find how far down the list the filename is
  if (SeedFilename[0]) {
    FileNamePtr = Head;
    for (i=1; (i <= MaxNames) && (strcmp(FileNamePtr->Name, SeedFilename) != 0); ++i)
      FileNamePtr = FileNamePtr->NextPtr;
    if (i <= MaxNames)
      SeedNumber = i;
  }
}
