/* filename: ITEMNAVG.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
#include <sayget.h>
#include <dbf.h>
#include <pick.h>
  
void FillBox(void);
void UnPaintBar(void);
char * UsersString(int i);
void PaintBar(void);
  
extern int StartingItem;
extern int FirstItem;
extern int ItemNo;
extern int LastItem;
extern int MaxItem;
extern int MaxVisibleItems;
extern int MinItem;
extern PickWindowPtr CurrentWindow;
extern BOOL Chiselled;
  
static void ScrollDown(void)
{
  int rmin, cmin;
#ifdef _MSC_VER
  short left, top, right, bottom;
  
  _gettextwindow(&top, &left, &bottom, &right);
  rmin = top;
  cmin = left;
  _settextwindow(CurrentWindow->r1+rmin+1, CurrentWindow->c1+cmin+1,
  CurrentWindow->R2+rmin-1, CurrentWindow->c2+cmin-1);
  _settextposition(1,1);
  HideMouse();
  _scrolltextwindow(-1);
  ShowMouse();
  _settextwindow(1, 1, MaxAvailRows(), 80);
#else
  struct text_info ti;
  
  gettextinfo(&ti);
  rmin = ti.wintop;
  cmin = ti.winleft;
  window(CurrentWindow->c1+cmin+1, CurrentWindow->r1+rmin+1,
  CurrentWindow->c2+cmin-1,  CurrentWindow->R2+rmin-1);
  gotoxy(1,1);
  HideMouse();
  // go to corner of the window and insert a line
  insline();
  ShowMouse();
  window(1,1,80,MaxAvailRows());
#endif
  
  --FirstItem;
  if (FirstItem < MinItem)
    FirstItem = MinItem;
  LastItem = FirstItem + MaxVisibleItems - 1;
  if (LastItem > MaxItem)
    LastItem = MaxItem;
  At(CurrentWindow->r1+1, CurrentWindow->c1+1, UsersString(FirstItem));
  ItemNo = FirstItem;
}
  
static void ScrollUp(void)
{
  char tempstr[STRSIZ];
  int rmin, cmin;
#ifdef _MSC_VER
  short left, top, right, bottom;
  
  _gettextwindow(&top, &left, &bottom, &right);
  rmin = top;
  cmin = left;
#else
  struct text_info ti;
  
  gettextinfo(&ti);
  rmin = ti.wintop;
  cmin = ti.winleft;
#endif
  
  ++LastItem;
  if (LastItem > MaxItem)
    LastItem = MaxItem;
  FirstItem = LastItem - MaxVisibleItems + 1;
  strcpy(tempstr,UsersString(LastItem));
  
  if (strlen(tempstr) > 0) {  //  Length = 0 means we got EOF, so DON'T Scroll
#ifdef _MSC_VER
    _settextwindow(CurrentWindow->r1+rmin+1, CurrentWindow->c1+cmin+1,
    CurrentWindow->R2+rmin-1, CurrentWindow->c2+cmin-1);
    _settextposition(1,MaxVisibleItems);
    HideMouse();
    _scrolltextwindow(1);
    ShowMouse();
    _settextwindow(1, 1, MaxAvailRows(), 80);
#else
    window(CurrentWindow->c1+cmin+1, CurrentWindow->r1+rmin+1,
    CurrentWindow->c2+cmin-1,  CurrentWindow->R2+rmin-1);
    gotoxy(1,MaxVisibleItems);
    HideMouse();
    cprintf("\r\n");
    ShowMouse();
    window(1, 1, 80, MaxAvailRows());
#endif
    At(CurrentWindow->R2-1, CurrentWindow->c1+1, tempstr);
  }
  if (LastItem > MaxItem)
    LastItem = MaxItem;
  FirstItem = LastItem - MaxVisibleItems + 1;
  ItemNo = LastItem;
}
  
void GoToPriorItem(void)
{
  if (ItemNo > MinItem) {
    UnPaintBar();
    --ItemNo;
    if (ItemNo < FirstItem)
      ScrollDown();
    PaintBar();
  }
}
  
void GoToNextItem(void)
{
  if (ItemNo < MaxItem) {
    UnPaintBar();
    ++ItemNo;
    if (ItemNo > LastItem)
      ScrollUp();
    PaintBar();
  }
}
  
void GoToTopItem(void)
{
  ExplodeModeType SaveExplodeMode;
  BOOL tmp;
  
  UnPaintBar();
  StartingItem = MinItem;
  SaveExplodeMode = ExplodeMode;
  ExplodeMode = NEVER;
  // clear the interior of the window
  tmp = Chiselled;
  Box(CurrentWindow->r1+1, CurrentWindow->c1+1, CurrentWindow->R2-1,
  CurrentWindow->c2-1, NoLine, "");
  Chiselled = tmp;
  ExplodeMode = SaveExplodeMode;
  FillBox();
  ItemNo = FirstItem;
  PaintBar();
}
  
void GoToBottomItem(void)
{
  do {
    GoToNextItem();
  }  while (!((ItemNo == MaxItem) || KeyPressed()));
}
  
void ResetMaxItem(int i)
{
  MaxItem = i;
  GoToTopItem();
}
