/* filename: FILLBOX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <sayget.h>
#include <dbf.h>
#include <pick.h>
  
extern int FirstItem;
extern int ItemNo;
extern int LastItem;
extern int MaxItem;
extern int MaxVisibleItems;
extern int MinItem;
extern int StartingItem;
extern int CurrentItem;
extern PickWindowPtr CurrentWindow;
  
char * UsersString(int i);
  
void FillBox(void)
{
  int i, i1, i2;
  char StringItem[STRSIZ];
  long InitialRecNo;
  
  if (StartingItem == 0) {
  
    /* "0" means that the user is working with an indexed file
    to know the StartingItem number, we need to go to the
    first item and work down til we get to the current record  */
  
    if (dEOF())
      GoBottom();
    Skip(0);   /* get everything lined up..the guy might have set a
    filter without positioning the database..that will
    mean a potential infinite loop below:  */
  
    InitialRecNo = RecNo();
    StartingItem = MinItem;
  
    /* if a WHILE function is active, assume the dbf is positioned at the
    first record and we are ready to go. Otherwise, GoTop and find out
    how many records deep we are */
  
    if (WorkArea[Selected]->WhileFunc == NULL) {
      GoTop();
      while (InitialRecNo != RecNo()) {
        StartingItem++;
        Skip(1);
      }
    }
    CurrentItem = StartingItem;
  }
  i1 = StartingItem - (MaxVisibleItems / 2);
  if (i1 < MinItem)
    i1 = MinItem;
  i2 = i1 + MaxVisibleItems - 1;
  if (i2 > MaxItem)
    i2 = MaxItem;
  FirstItem = i1;
  LastItem = i2;
  
  i = FirstItem;
  do {
    strcpy(StringItem, UsersString(i));
    At(CurrentWindow->r1+i-FirstItem+1, CurrentWindow->c1+1, StringItem);
    ++i;
  }  while (!((i > LastItem) || (i > MaxItem)));
}
