/* filename: MEMOOPEN.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <string.h>
#include <utils.h>
#include <memo.h>

void ClearLineBuffers(int);
int  GetLineBuffers(void);
void MakeDynString(char *, int);
int  NoMem(void);
long WriteMemoF(long);

int  MemoCurrentLine;
extern char *MemoLineTails;
static char _tzfar TempLine[STRSIZ] = "", _tzfar fname[] = {" [OpenMemo]"};

int MemoInOut(MemoFile *f)
// this routine needs to be modified to handle word-wrapped text!
{
   int result;
   char _temp[STRSIZ], ch;
   unsigned char SaveArea;

   if (!Txtin)
      return 104;
   SaveArea = Selected;
   Selected = f->Selected;

   result = 0;

   switch ( (f->mode) & 0xFF) {
      case _fmOutput: // put a string to a memo
         if (f->BufPos == 0)
            goto Bailout; // no chars to process
         if ((unsigned int)MemoCurrentLine > MaxLines) {
            // the "disk" just became full!
            result = 101;
            goto Bailout;
         }
         // new way...works with WriteToAlt
         strncpy(_temp,f->BufPtr, f->BufPos);
         _temp[f->BufPos] = 0;
         ch = _temp[strlen(_temp)-1];
         if (ch == '\n') {
           ch = _temp[strlen(_temp)-2];
           if (ch == '')
             MemoLineTails[MemoCurrentLine-1] = '';
           else
             MemoLineTails[MemoCurrentLine-1] = '\r';
         }
         // remove any carriage returns and line feeds
         while (Pos("\r",_temp) >= 0)
            Delete(_temp,Pos("\r",_temp), 1);
         while (Pos("\n",_temp) >= 0)
            Delete(_temp,Pos("\n",_temp), 1);
         strcat(TempLine,_temp);
         Highestline = MemoCurrentLine;
         MakeDynString(TempLine,MemoCurrentLine-1);
         ++MemoCurrentLine;
         *TempLine = 0;
         if (NoMem()) {
            // "disk write error"
            result = 101;
            goto Bailout;
         }
         f->BufPos = 0;
         break;

      case _fmInput: // read a string from a memo
         if ((MemoCurrentLine > Highestline) || (*Linebuffer == NULL)) {
         // either there is no memo, or we are reading past "eof"
            f->BufEnd = 0; // this is how we let turbo know we are at eof
            f->BufPos = 0;
            goto Bailout;
         }
         strcpy(_temp, Linebuffer[MemoCurrentLine-1]);
         if (strlen(_temp) > 253)
            _temp[253] = 0;
         f->BufEnd = strlen(_temp);
         strcpy(f->BufPtr, _temp);
         *EndE = MemoLineTails[MemoCurrentLine-1];
         strcat(f->BufPtr, EndE);
         f->BufEnd += 2;
         if (DBMemoType == DB4WithDB4Memo)
           f->BufPos += f->BufEnd; // per the manual
         else
           f->BufPos = 0;
         ++MemoCurrentLine;
         break;

      default:
         result = 102; // "file not assigned"
   }
Bailout:
   Selected = SaveArea;
   return result;
}

int MemoFlush(MemoFile *f)
{
   switch (f->mode & 0xFF) {
      case _fmInput:
         f->BufPos=0;
         f->BufEnd=0;
         break;

      case _fmOutput:
         return MemoInOut(f);
   }
   return 0;
}

int MemoClose(MemoFile *f)
{
   unsigned char SaveArea;
   long MemoBlockNo;

   SaveArea = Selected;
   Selected = f->Selected;
   if (f->mode == _fmOutput) // it was a ReWrite or an Append
      if (!(MemoBlockNo = WriteMemoF(*f->MemoPtr))) // Multi-user locking handled by WriteMemoF
         SetError(errno, 3, Error_writing , DBT(), " [CloseMemo]"); // "disk write error"
      else {
         *(f->MemoPtr) = MemoBlockNo;
      }
   ClearLineBuffers(TRUE); // dispose of memory
   Selected = SaveArea;
   // dispose of memory used for device buffer
   FreePtrClear((void *)&f->BufPtr);
   return 0;
}

int MemoOpen(MemoFile *f)
{
   int AlreadyOpen;
   int result = 0;
   unsigned char SaveArea;

   SaveArea = Selected;
   // make sure we are on current database
   Selected = f->Selected;

   if (f->BufPtr == NULL) {
      if((f->BufPtr = (char *)malloc(255)) == NULL) {
         result = 8; // not enough memory
         goto Bailout;
      }
      f->BufSize = 255;
      f->BufPos = 0; // Only do the rest of this stuff
      f->BufEnd = 0; // when we originally "open" the memo
      f->InOutFunc = MemoInOut;
      f->FlushFunc = MemoFlush;
      f->CloseFunc = MemoClose;
      AlreadyOpen = FALSE;
   }
   else
      AlreadyOpen = TRUE;

   switch (f->mode & 0xFF) {
      case _fmInput: // "Reset"
         if (!AlreadyOpen) {
            if (!Txtin)
               if (!GetLineBuffers()) {
                  result = 8; // not enough memory
                  goto Bailout;
               }
            if (!GetMemo(*(f->MemoPtr), fname))
               result = 100;
         }
         MemoCurrentLine = 1;
         break;

      case _fmInOut:  // "Append"
         f->mode = _fmOutput;
         if (!AlreadyOpen) {
            if (!Txtin)
               if (!GetLineBuffers()) {
                  result = 8; // not enough memory
                  goto Bailout;
               }
            if (!GetMemo(*(f->MemoPtr), fname))
               result = 100;
         }
         MemoCurrentLine = Highestline + 1;
         if (Highestline == 1) { //just because HighestLine is 1, doesn't mean the mean isn't empty
            if (*Linebuffer == NULL)
               MemoCurrentLine = 1;
            else
               if (Linebuffer[0][0] == 0)
                  MemoCurrentLine = 1;
         }
         *TempLine = 0;
         break;

      case _fmOutput:  // "ReWrite"
         if (AlreadyOpen) // then FLUSH out what's there
            ClearLineBuffers(TRUE); // dispose of memory
         if (!Txtin)  // ?? Perhaps we should generate an Error ??
            if (!GetLineBuffers())
               result = 8; // not enough memory
         MemoCurrentLine = 1;
         Highestline = 1;
         *TempLine = 0;
         break;

      default:
         result = 102; // "file not assigned"
   }
   if (!MemoLineTails) {
     if ((MemoLineTails = (char *)malloc((unsigned)(MaxLines+1))) == NULL) {
       SetError(217, 1, fname);
       result = 100;
     }
     else
       memset(MemoLineTails,0,sizeof(MaxLines+1));
   }
Bailout:
   Selected = SaveArea;
   return result;
}
