/* filename: EDITMEMO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <memo.h>

void ClearLineBuffers(int );
long WriteMemoF(long);
int GetLineBuffers(void);

extern unsigned char WordWrapWidth;
extern char *MemoLineTails;

static char _tzfar funcname[] = "EditMemo";
static char _tzfar funcname1[] = " [EditMemo]";


void EditMemo(long *Memoadd, char *Parms)
{
  unsigned char SaveWordWrapWidth;

  if (!CheckRegisteredUnits(funcname,
      REGTZCOMMON+REGTZDBF+REGTZVIDPOP+REGTZSAYGET+REGTZMEMO))
    return;
  if (NoMemoInUse(funcname))
    return;
  if (!GetLineBuffers()) {
    SetError(InsufficientMemory, 2, DBT(), funcname1);
    return;
  }
  if (strstr(Upper(Parms),"SHOW"))
    Show = TRUE;
  if (GetMemo(*Memoadd,funcname1)) {
    MemoIn = TRUE;
    if (!EditorPresent) {
      SetError(InvalidParameter, 2, Editor_unit_not_linked_in, funcname1);
      ClearLineBuffers(TRUE);
      return;
    }
    else {
      SaveWordWrapWidth = WordWrapWidth;
      (*EditorRoutines.EditTextProc)(Parms); // same as EditText(Parms);
      WordWrapWidth = SaveWordWrapWidth;
    }
    MemoIn = FALSE;
    switch (EditorResult) {
      case 0:
      case 1: FreePtrClear((void*)&MemoLineTails); break;
      case 2: *Memoadd = WriteMemoF(*Memoadd); break;
      case 3: *Memoadd = 0; break;
    }
  }
  Show = FALSE;
  ClearLineBuffers(TRUE);
}
#endif // not WINDOWS
