/* filename: DISPMEMO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <memo.h>

int  GetLineBuffers(void);
void ClearLineBuffers(int);
void Reformat(unsigned char, unsigned char);

char _tzfar MemoTitle[81] = "";
unsigned char MemoStyle = 0;
extern char *MemoLineTails;

void DisplayMemo(long BlockNumber)
{
  int SaveOrder, SaveWrap, MaxDisplayLine, i;
  unsigned char SaveLmargin, SaveRmargin;
  unsigned char WindowWidth, WindowDepth;
#ifdef _MSC_VER
  int y1, x1, y2, x2;
#else
  struct text_info ti;
#endif

  if (NoMemoInUse("DisplayMemo"))
    return;
  SaveOrder = dBASEOrder;
  dBASEOrder = FALSE;
#ifdef _MSC_VER
  _gettextwindow(&y1, &x1, &y2, &x2);
  SaveWrap = _wrapon(_GWRAPOFF);
#else
  gettextinfo(&ti);
  SaveWrap = _wscroll;
  _wscroll = 0;
#endif
  // draw box first
  Box(MemoX1,MemoY1,MemoX2,MemoY2-1,MemoStyle,MemoTitle);
  if ((MemoStyle & 0xF) == 0) { // no line style
    WindowWidth = MemoX2 - MemoX1 + 1;
    i = *MemoTitle ? 1 : 0; // take over the header line
    WindowDepth = MemoY2 - MemoY1 - i - 1;
    window(MemoX1,MemoY1 + i, MemoX2, MemoY2-1);
  }
  else { // the display area is bounded by a line
    WindowWidth = MemoX2 - MemoX1 - 2; // maximum column in window is not available for characters
    WindowDepth = MemoY2 - MemoY1 - 3;
    window(MemoX1 + 1,MemoY1 + 1,MemoX2 - 1,MemoY2-1);
  }
  if (BlockNumber > 0) {
    SaveLmargin = MemoLMargin;
    SaveRmargin = MemoRMargin;
    SetMemoWidthTo(0,WindowWidth);

    if (GetLineBuffers()) {
      if (GetMemo(BlockNumber, " [DisplayMemo]")) {
        if (Wrap)
          Reformat(0,WindowWidth);
        MaxDisplayLine = WindowDepth;
        if (Highestline < (long)MaxDisplayLine)
          MaxDisplayLine = Highestline;
        for (i = 0; i < MaxDisplayLine; i++) {
#ifdef _MSC_VER
          if(Linebuffer[i])
            _outtext(Linebuffer[i]);
          if (i != (int)(MaxDisplayLine - 1))
            _outtext("\r\n");
#else
          if(Linebuffer[i])
            cprintf(Linebuffer[i]);
          if (i != (int)(MaxDisplayLine - 1))
            cprintf("\r\n");
#endif
        }
      }
      ClearLineBuffers(TRUE);
      FreePtrClear((void*)&MemoLineTails);
    }
    else // just announce the out-of-memory error in window
      puts(ERROR_Insufficient_memory_to_display_memo);
    SetMemoWidthTo(SaveLmargin,SaveRmargin);
  }
  dBASEOrder = SaveOrder;
#ifdef _MSC_VER
  _wrapon(SaveWrap);
  window(x1, y1, x2, y2);
#else
  window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
  _wscroll = SaveWrap;
#endif

}
#endif // NOT WINDOWS
