/* filename: COPMEMFR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <memo.h>

long CopyMemo(unsigned char *, long *);
long NewMemoByteOffset(char *);
void UpdateMemoHeader(void);

long CopyMemoFrom(unsigned char FromArea, long OriginalMemoField)
{
  if (NoMemoInUse("CopyMemoFrom"))
    return 0;
  return CopyMemo(&FromArea,&OriginalMemoField);
}

long CopyMemo(unsigned char *FromFile, long *MemoOffset)
// copies the memo in the FromFile starting at MemoOffset to a memo in the ToArea
// and returns the offset
{
  long          address;
  unsigned char Buffer[BsizePlusOne];
  int           i;
  unsigned int  BytesRead;

  if (!*MemoOffset)
    return 0L;
  // prepare the ToArea memo first
  address = NewMemoByteOffset(" [CopyMemoFrom]"); // now positioned at eof, ready for next memo
  if (!address)
    return 0L;
  fseek(WorkArea[*FromFile]->MemoArea->Memofile,*MemoOffset * 512,SEEK_SET);
  DBFError = errno;
  if (DBFError) {
    SetError(DBFError, 2, DBT(), " [AppendFrom/CopyTo]");
    return 0L;
  }

  do {
    BytesRead = read( fileno(WorkArea[*FromFile]->MemoArea->Memofile),Buffer,sizeof(Buffer) - 1);
    write( fileno(WorkArea[Selected]->MemoArea->Memofile),Buffer,BytesRead);
    if (DBFError) {
      SetError(DBFError, 2, DBT(), " [AppendFrom/CopyTo]");
      return 0;
    }
    // is there a ^Z in this block of data?
    i = 0;
    do {
      ++i;
    }  while (!((Buffer[i-1] == (unsigned char)('\x1A')) || ((unsigned)i > BytesRead)));
  }  while (!((Buffer[i-1] == (unsigned char)('\x1A')) || (BytesRead == 0)));
  UpdateMemoHeader();
  return (address / 512);
}
