/* filename: ADDMEMO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <memo.h>

long NewMemoByteOffset(char *);
void UpdateMemoHeader(void);
void GroupHeader(long *, GROUP_HDR *, int);
void MainHeader(long *, int);

long AddMemo(char * s)
// creates a new memo in the current Area containing the string s and returns the offset
{
  int fhandle;
  long address;
  GROUP_HDR gr_hdr;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  DBMemoType = WorkArea[Selected]->Handle.HasMemo;

  if (!Trim(s))
    return 0L;
  address = NewMemoByteOffset(" [AppendFrom]");
  if (!address)
    return 0L;
  address /= Bsize;
  if(DBMemoType == DB4WithDB4Memo) {
    MainHeader(&address,1);
    gr_hdr.flag = -1;
    gr_hdr.header_length = 8;
    gr_hdr.group_length = strlen(s)+8;
    GroupHeader(&address,&gr_hdr,1) ;
    lseek(fhandle,address*Bsize+8,SEEK_SET);
  }
  else {
    strcat(s,"\x1A");
    // tack on the end-of-memo marker
    UpdateMemoHeader();
  }
  write(fhandle,s,strlen(s));
  return (address);
}
