/* filename: ACTIVMEM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#include <dbf.h>
#include <memo.h>

double ActiveMemos(void) // returns fraction of memo file with active data
{
  int fhandle;
  long TotalBlocks, InvalidBlocks;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);

  if (NoMemoInUse("ActiveMemos"))
    return 1.0;

  lseek(fhandle, 0L, SEEK_SET);
  read(fhandle,&TotalBlocks,sizeof(TotalBlocks));
  lseek(fhandle,32L, SEEK_SET);
  read(fhandle,&InvalidBlocks,sizeof(InvalidBlocks));
  --TotalBlocks; // because of the header
  if (TotalBlocks < 1)
    return 1.0;

  return (1.0 - InvalidBlocks / TotalBlocks);
}
