/* filename: RESTRFRM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <math.h>
#include <fcntl.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>
#include <tzmem.h>

LinkType *MemPtr = NULL;

static LinkType *Ptr;
static int f; // file handle

static void ClearMemPtr(LinkType *ptr)
{
  while (ptr) { // deallocate the nodes we allocated so far
    if (ptr->Typ == 'C')
      free(ptr->StrPtr);
    free(ptr);
    ptr = ptr->NextPtr;
  }
}

static void CleanUp(void) // deal with memory and file in case of error
{
  ClearMemPtr(Ptr);
  close(f);
}

void ClearMem(void) // user's function
{
  ClearMemPtr(MemPtr);
}

void RestoreFrom(const char *memFile)
{
  LinkType *TempPtr;
  MemHeader Header;
  char typ, size, *err_msg, fname[80];
  int  BytesRead;

  strcpy(fname, Trim(memFile));
  if (!*fname) {
    ClearMem();
    return;
  }
  strcpy(fname, Upper(AddExt(fname, "MEM")));
  if (!FileExists(fname)) {
    SetError(2, 2, fname, " [RestoreFrom]");
    return;
  }
  Ptr = NULL;
  f = open(fname, O_RDONLY | O_BINARY);
  if (f == -1) {
    SetError(errno, 4, _attempting_to_, open_, fname, " [RestoreFrom]");
    return;
  }
  while (TRUE) {
    BytesRead = read(f, &Header, sizeof(Header));
    if ((BytesRead == 1) && (Header.Name[0] == '\x1A')) {
      if (close(f))
        SetError(errno, 4, _attempting_to_, close_, fname, " [RestoreFrom]");
      else {
        ClearMem();
        MemPtr = Ptr;
      }
      return;
    }
    if (BytesRead != sizeof(Header))
      goto error_reading;
    if (((char)Header.TypeID == '\xC3') || ((char)Header.TypeID == '\xC4') ||
      ((char)Header.TypeID == '\xCC') || ((char)Header.TypeID == '\xCE'))
      Header.TypeID &= 0x00FF;
    switch (Header.TypeID) {
      case 0x02C1:
        err_msg = dBASE_Array_types_not_supported;
        goto invalid_parameter;
      case 0xC3:
        typ = 'C';
        size = Header.Len;
        break;
      case 0xC4:
        typ = 'D';
        size = sizeof(double); // dates are stored as julians in ieee real format
        break;
      case 0x00C6:
        err_msg = Invalid_numeric;
        goto invalid_parameter;
      case 0x01C6:
        err_msg = BCD_type_not_supported;
        goto invalid_parameter;
      case 0x02C6:
        typ = 'I'; // signed integer
        size = sizeof(int);
        break;
      case 0x00CC:
        typ = 'L'; // boolean
        size = sizeof(char);
        break;
      case 0x00CE:
        typ = 'F'; // ieee floating point
        size = sizeof(double);
        break;
      default:
        err_msg = Unrecognized_data_type;
        goto invalid_parameter;
    }
    TempPtr = Ptr; // add a new link to the linked list
    if ((Ptr = malloc(sizeof(LinkType))) == NULL) {
      CleanUp();
      SetError(InsufficientMemory, 3, " [RestoreFrom(", fname, ")]");
      return;
    }
    Ptr->NextPtr = TempPtr;
    memcpy(Ptr->Name, Header.Name, 10); // fill in the variable name
    Ptr->Name[10] = 0;
    Ptr->Typ = typ; // fill in the data type
    Ptr->StrPtr = NULL;
    switch (typ) { // read the data
      case 'C':
        if ((Ptr->StrPtr = malloc(size)) == NULL) {
          CleanUp();
          SetError(InsufficientMemory, 3, " [RestoreFrom(", fname, ")]");
          return;
        }
        if (read(f, Ptr->StrPtr, size) != size)
          goto error_reading;
        Ptr->StrPtr[size-1] = 0;
        break;
      case 'D':
        if (read(f, Ptr->Data, size) != size)
          goto error_reading;
        *((long*)Ptr->Data) = (long) floor(*(double*) Ptr->Data);
        strcpy(Ptr->Data, DateFromJulian(*((long*) Ptr->Data)));
        break;
      default:
        if (read(f, Ptr->Data, size) != size)
          goto error_reading;
    }
  }
invalid_parameter:
  CleanUp();
  SetError(InvalidParameter, 4, err_msg, " [RestoreFrom(", fname, ")]");
  return;
error_reading:
  CleanUp();
  SetError(100, 2, fname, " [RestoreFrom()]");
  return;
}


