/* filename: MEMFUNCS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <sayget.h>
#include <timedate.h>
#include <tzmem.h>

extern LinkType *MemPtr;

static LinkType *TempPtr;

static int CheckMemVars(const char *funcname)
{
  if (!MemPtr) {
    SetError(230, 2, No_memory_vars_loaded, funcname);
    return 0;
  }
  return 1;
}

static int CheckCount(int i, const char *funcname)
{
  if (i > MemCount()) {
    SetError(InvalidParameter, 3, SInteger(i, 0), " > MemCount ", funcname);
    return 0;
  }
  return 1;
}

static void FindMem(unsigned i)
{
  TempPtr = MemPtr;
  while (i > 1) {
    TempPtr = TempPtr->NextPtr;
    i--;
  }
}

static int CheckAll(const char *fname, int i)
{
  if (CheckMemVars(fname))
    if (CheckCount(i, fname)) {
      FindMem(i);
      return 1;
    }
  return 0;
}

int MemCount(void)
{
  int count;

  if (!CheckMemVars("[MemCount]"))
  	return 0;
  TempPtr = MemPtr;
  count = 0;
  do {
    TempPtr = TempPtr->NextPtr;
    count++;
  }  while (TempPtr);
  return count;
}

char *MemName(unsigned i)
{
  if (!CheckAll("[MemName]", i))
  	return "";
  return TempPtr->Name;
}

char MemType(unsigned i)
{
  if (!CheckAll("[MemType]", i))
  	return 'U';
  return TempPtr->Typ;
}

void *MemAddr(unsigned i)
{
  if (!CheckAll("[MemAddr]", i))
  	return NULL;
  if (TempPtr->Typ == 'C')
    return TempPtr->StrPtr;
  else
    return TempPtr->Data;
}

int Mem(const char * varname)
{
  int i;
  char name[80];

  if (!CheckMemVars("[Mem]"))
  	return 0;
  strcpy(name, Upper(Trim(varname)));
  if (!*name) {
    SetError(InvalidParameter, 1, " [Mem()]");
    return 0;
  }
  TempPtr = MemPtr;
  for(i = 1; TempPtr; ++i) {
    if (!strcmp(Upper(TempPtr->Name), name))
      return i;
    TempPtr = TempPtr->NextPtr;
  }
  return 0;
}

void AddMem(const char *memName, char Typ, void *memvar)
{
  int  NewVar, errid;
  char Name[80];

  // things to check:
  //  1. the name is not blank
  //  2. the typ is valid
  //  3. there is enough memory to malloc
  //  4. are we adding a memvar or replacing an existing one?
  // check that the name is not already in the list..if it is,
  // we want to replace the data

  strcpy(Name, Upper(Trim(memName)));
  if (!*Name) {
    errid = InvalidParameter;
    goto err_exit;
  }
  NewVar = !(MemPtr ? Mem(Name) : 0);
  Typ = toupper(Typ);
  if (!strchr("CLIDF", Typ) && Typ) {
    errid = InvalidParameter;
    goto err_exit;
  }
  TempPtr = MemPtr;
  if (NewVar) { // if this is a new memvar, add a new link to the linked list
    if ((MemPtr = malloc(sizeof(LinkType))) == NULL) {
      errid = InsufficientMemory;
      goto err_exit;
    }
    MemPtr->NextPtr = TempPtr;
    MemPtr->StrPtr = NULL;
    strcpy(MemPtr->Name, Name); // fill in the variable name
  }
  else { // otherwise, locate the link with the existing data
    while (strcmp(Upper(MemPtr->Name), Name))
        MemPtr = MemPtr->NextPtr;
    // if the existing link has a string pointer, deallocate the memory
    if (MemPtr->StrPtr) {
      free(MemPtr->StrPtr);
      MemPtr->StrPtr = NULL;
    }
  }
  MemPtr->Typ = Typ; // fill in the data type
  switch (Typ) {
    case 'C':
      if ((MemPtr->StrPtr = malloc(strlen((char*)memvar) + 1)) == NULL) {
        errid = InsufficientMemory;
        goto err_exit;
      }
      strcpy(MemPtr->StrPtr, (char *) memvar);
      break;
    case 'D':
      strcpy(MemPtr->Data, (char*) memvar);
      break;
    case 'I':
      *((int*) MemPtr->Data) = * (int*) memvar;
      break;
    case 'L':
      *MemPtr->Data = * (char*) memvar;
      break;
    case 'F':
      *((double*) MemPtr->Data)  = * (double*) memvar;
      break;
  }
  if (!NewVar)
     MemPtr = TempPtr;
  return;

err_exit:
  SetError(errid, 1, " [AddMem()]");
}
