/* filename: STORE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <sayget.h>
#include <index.h>

#ifdef NDX_TYPE
static void StoreEmptyKeys(void)
{
  PIndexType p;
  int j;

  for(j = 0; j < MaxOrder; j++) {
    p = Ind[Selected][j];
    if (p)
      if (p->kiss) {
        memset(p->KeyStorage, ' ',p->header.key_len);
        p->KeyStorage[p->header.key_len] = 0;
      }
      else
        memset(p->KeyStorage, 0, p->header.key_len);
  }
}
#endif

void StoreCurrentKeys(void)
{
  PIndexType p;
  int  order, k_len;
  char key[101], buf1[40], buf2[40];

#ifdef NDX_TYPE
  if (!RecNo() || !RecCount()) {
    StoreEmptyKeys();
    return;
  }
#endif

  for(order = 0; order < MaxOrder; order++) {
    p = Ind[Selected][order];
    if (p) {
#ifdef NDX_TYPE
      k_len = p->header.key_len;
      SyncPOrder = order; // this is for the parser
      memcpy(key, FarKey(order), k_len+1);
      if (strlen(key) == (size_t) k_len || !p->kiss)
#else
      k_len = p->KeyLength;
      memcpy(key, FarKey(order), k_len+1);
      if (strlen(key) == (size_t) k_len)
#endif
        memcpy(p->KeyStorage, key, k_len + 1);
      else {
        sprintf(buf1, "RecCount: %ld ", RecCount());
        sprintf(buf2, "RecNo: %ld ", RecNo());
        SetError(BadSize,13,incorrect_key_length_returned_by_user_defined_keymaker,
          "\r\n", expected_length, SInteger(k_len, 3), "\r\n",
          key_equals,"[",key,"] ",IndexName(order),
          " [StoreCurrentKeys]\n\r", buf1, buf2);
        assertJumper();
      }
    }
  }
}


