/* filename: SOUNDEX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sayget.h>

extern unsigned char SoundexLength;

char * Soundex(char * s)
// ignores spaces and other non-alphabetic characters
// Del Largo is treated like DelLargo (same as Delargo)
// Id-Deen is treated like Iddeen
{
   char SoundexTable[27]  = "01230120022455012623010202";
   char CurrentChar, PreviousChar;
   int  i;	//  index in result string
   int  j;  //  index in source string
   static char result[10];

   result[SoundexLength] = 0;
   memset(result, '0', SoundexLength);
   UpperString(s);

   result[0] = s[0];
   if (isalpha(s[0]))
      PreviousChar = SoundexTable[s[0]-'A'];
   else
      PreviousChar = '0';

   for(i=j=1;(i < (int)SoundexLength) && (j < (int)strlen(s)); j++) {
      if (isalpha(s[j])) {
         CurrentChar = SoundexTable[s[j]-'A'];
         if (CurrentChar != PreviousChar) {
            if (CurrentChar != '0')
               result[i++] = CurrentChar;
            PreviousChar = CurrentChar;
         }
      }
   }
   return result;
}
