/* filename: SETUNIQ.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <ctype.h>
#include <index.h>
#ifdef NDX_TYPE
int  UniqueOn = 0;        // default is FALSE;
// so far UniqueOn effects MakeIndex() function only

void SetUniqueOn(void)
{
  UniqueOn = 1;
}

void SetUniqueOff(void)
{
  UniqueOn = 0;
}
#endif // NDX_TYPE

char * SqueezeExpression(char * string, int filename)
{
  char delimeter;
  char *from, *to, buf;

  for(delimeter=0, from=to=string; *from; from++) {
    if (delimeter) {
      if (*from == delimeter) {
        *from = filename ? delimeter : '"';
        delimeter = 0;
      }
      *to++ = *from;
    }
    else
    switch (*from) {
      case '\t' :
      case ' '  :
        if (filename) {
          buf = *(from+1);
          if (buf != ' ' && buf != '\t' && buf != '=' && buf != '\'' && buf != '\"' && buf)
            *to++ = ' ';
        }
        break;
      case '\"' :
      case '\'' : delimeter = *from;
        *to++ = filename ? delimeter : '\"';
        break;
      default   : *to++ = toupper(*from);
        break;
    }
  }
  *to = 0;
  return string;
}
  
