/* filename: SEEK_RED.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <index.h>

#ifdef NDX_TYPE

BOOL SeekAndRead(int area, int order, long position, void *blocktoread)
{
  PIndexType p;
  PNDXBlock block;
  void *vptr;
  int handle;

  p = Ind[area][order];
  if ((vptr = ScanPaths(position, area, order)) != NULL) {
    if (vptr != blocktoread)
      memcpy(blocktoread, vptr, BLOCK_SIZE);
    return TRUE;
  }
  handle = p->Ndx;
  lseek(handle, position*BLOCK_SIZE, SEEK_SET);
  if (read(handle,blocktoread, BLOCK_SIZE ) != BLOCK_SIZE) {
    SetError(_doserrno,2,error_reading_index_file, IndexName(order));
    assertJumper();
    return FALSE;
  }
  // clear MODIFIED flag
  block = (PNDXBlock) blocktoread;
  block->modified = 0;
  return TRUE;
}

#else

BOOL SeekAndRead(int area, int order, long position, PNode nodetoread)
{
  Node   node;
  size_t nodesize;
  int    key_len, handle;
  PIndexType  p;

  p = Ind[area][order];
  nodesize = (size_t)p->NodeSize;
  key_len  = p->KeyLength;
  handle = p->Ndx;

  lseek(handle, position*nodesize, SEEK_SET);
  if (read(handle,&node,nodesize ) != (int) nodesize) {
    SetError(_doserrno,2,error_reading_index_file,IndexName(order));
    assertJumper();
    return FALSE;
  }
  memcpy (nodetoread, &node, nodesize);
  if (position) { // if not anchor node
    memcpy (nodetoread->Key, &node.Key[1], key_len);
    nodetoread->Key[key_len] = 0;
  }
  return TRUE;
}
#endif // NDX_TYPE
