/* filename: SDX2PRIM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <sayget.h>
#include <index.h>

extern int OrderChanged;
extern jmp_buf Jumper;

static void SetIndexToPrim(PUDK_func udk, char *filename, int order)
{
  char *expr = 0;
  int cacheenabled, soundex, descending, j;

  if (!CheckRegisteredUnits("SetIndexTo", REGTZCOMMON+REGTZDBF+REGTZINDEX))
    return;
  if (setjmp(Jumper))
    return;
  DBFError = 0;
  if ((order > MaxOrder) || (order <= 0)) { // do some error checking first
    SetError(InvalidParameter,6,index_order_parameter_out_of_range,
    " [SetIndexTo(<...>,",filename,", ", SInteger(order,0),")]");
    return;// if not autohalt let the programmer handle his own errors
  }
  --order; // now make order 0-based for internal use
#ifndef NDX_TYPE
  if (Ind[Selected][order]) {// close the index file and release some memory
    CloseOneIndex(Selected, order);
    if (DBFError)
      return;
  }
#endif
  SqueezeExpression(filename, 1);
  if (!*filename)// no filename: user is just asking to close an index file
    return;
  // look for clauses in the filename
  soundex = strstr(filename, " SOUNDEX") != NULL;
  descending = strstr(filename, " DESCENDING") != NULL;
  cacheenabled = strstr(filename, " NOCACHE") == NULL;
#ifdef NDX_TYPE
  if ((expr = strstr(filename, " EXPR=")) != NULL) {
    udk = NULL;
    expr = strchr(expr,'\'');
    if (expr)
      expr++;
    j = PosOf(1, "\'", expr);
    if (j > 0)
      *(expr + j) = 0;
  }
#endif
  j = PosOf(1, " ", filename); // get rid of clauses in the filename
  if (j > 0)
    *(filename + j) = 0;
#ifndef NDX_TYPE
  if (!udk) {
    SetError(InvalidParameter,6,Attempt_to_open_index_with_NIL_KeyMaker,
    ". [SetIndexTo(<>,",filename,",",SInteger(order+1,0),")]");
    return;
  }
#endif

#ifdef NET
  //#ifndef NDX_TYPE
  if (MultiUser)
    cacheenabled = FALSE;
  //#endif
#endif
  if (!*DBF()) {// no database is open
    SetError(NotInUse,8,attempt_to_open,filename,index_file_with_no_DBF_file_open,
    " [SetIndexTo(<>,",filename,",",SInteger(order+1,0),")]");
    return;
  }
  if (order != SyncOrder)
    OrderChanged = 1;
  SyncOrder = order;
#ifdef NET
  HandleSemaphore((char)Selected, Login);
  if (DBFError)
    return;
#endif
  if (!order) // if it is the primary index then initialize the order array
    OrderArray[Selected] = 0;// similar to SetOrderTo(1)
  // now call the engine that does the work
  OpenIndex(udk, filename, order, cacheenabled, soundex, descending, expr);
  if (DBFError)
    return;
  StoreCurrentKeys();
}

#ifdef NDX_TYPE
void SetIndexToCB(PUDK_func udk, const char *infname, int order)
#else
void SetIndexTo(PUDK_func udk, const char *infname, int order)
#endif
{
  char outfname[STRSIZ];
  int  saveErrNo;

  if (!infname)  // just checkin
    return;
  strncpy(outfname, infname, STRSIZ);
  outfname[STRSIZ-1] = 0;
  SetIndexToPrim(udk, outfname, order);
  saveErrNo = DBFError;
  SetOrderTo(1);
  if (SyncOrder)
    OrderChanged = 1;
  SyncOrder = 0;
  DBFError = saveErrNo;
}

#ifdef NDX_TYPE
void SetIndexTo(const char *infnames)
{
  char *cur_file, *nxt_file, fnames[STRSIZ];
  int   saveErrNo, NDXcount = 0;

  CloseIndexes();
  if (!infnames)  // parameter is NULL: user wants to close indexes
    return;
  strncpy(fnames, infnames, STRSIZ);
  fnames[STRSIZ-1] = 0;
  SqueezeExpression(fnames, 1);
  if (*fnames) {
    for(nxt_file = fnames; nxt_file;) {
      cur_file = nxt_file;
      nxt_file = strstr(nxt_file, " ");
      if (nxt_file)
        *nxt_file++ = 0;
      SetIndexToPrim(NULL, cur_file, ++NDXcount);
      if (DBFError) break;
    }
    saveErrNo = DBFError;
    SetOrderTo(1);
    if (SyncOrder)
      OrderChanged = 1;
    SyncOrder = 0;
    DBFError = saveErrNo;
  }
}
#endif

