/* filename: RLSEMPHR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef NET
#include <index.h>

void SetReadSemaphoreProc(int on)
{
  static int stack[MaxWorkAreas] = {0};
  if (on) {
    if (stack[Selected] == 0)
      HandleSemaphore((char)Selected, IncRead);
    ++stack[Selected];
  }
  else {
    if (--stack[Selected] < 0)
      SetError(254,1,"Non-symmetrical Lock-Unlock [SetReadSemaphoreProc]");
    else
      if (stack[Selected] == 0)
        HandleSemaphore((char)Selected, DecRead);
  }
}

void SetLockSemaphoreProc(int on)
{
  static int stack[MaxWorkAreas] = {0};
  if (on) {
    if (stack[Selected] == 0)
      HandleSemaphore((char)Selected, LockSemaphore);
    ++stack[Selected];
  }
  else {
    if (--stack[Selected] < 0)
      SetError(254,1,"Non-symmetrical Lock-Unlock [SetLockSemaphoreProc]");
    else
      if (stack[Selected] == 0)
        HandleSemaphore((char)Selected, UnlockSemaphore);
  }
}
#endif
