/* filename: QSORT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>

// pointer to user-defined comparison routine that compares two items
// and returns a value based on the comparison. (memcmp syntax !)
typedef int (*PUDC_func)(const void *, const void *, unsigned);

static PUDC_func cmp_routine;
static unsigned  k_len;

static int near compare(void **a, void **b)
{
  register int  ret;
  if ((ret = cmp_routine(*a, *b, k_len)) != 0)  return ret;
  return (*(long*)((char *)*a + k_len) > *(long*)((char *)*b + k_len)) ? 1 : (-1);
}

static void near QSortEngine(void **pivot, register unsigned p_number)
{
  void **left, **right, **temp1, **temp2, **temp3;
  unsigned lNum;
  register void *t;

start:
  if (p_number <= 2) {
    if (p_number == 2) {
      if (compare(pivot, right = pivot + 1) > 0) {
        t = *pivot;
        *pivot = *right;
        *right = t;
      }
    }
    return;
  }
  right = (p_number - 1) + pivot;
  left  = (p_number >> 1) + pivot;
  if (compare(left, right) > 0) {
    t = *left;
    *left = *right;
    *right = t;
  }
  if (compare(left, pivot) > 0) {
    t = *left;
    *left = *pivot;
    *pivot = t;
  }
  else
    if(compare(pivot, right) > 0) {
      t = *pivot;
      *pivot = *right;
      *right = t;
    }

  if (p_number == 3) {
    t = *pivot;
    *pivot = *left;
    *left = t;
    return;
  }
  left = temp1 = pivot + 1;
  do {
    while(compare(left, pivot) < 0) {
      if (left < right)
        ++left;
      else
        goto qBreak;
    }
    while(left < right) {
      if (compare(pivot, right) < 0)
        --right;
      else {
        t = *left;
        *left = *right;
        *right = t;
        ++left;
        --right;
        break;
      }
    }
  } while (left < right);
qBreak:
  if (compare(left, pivot) <= 0)
    ++left;
  temp3 = left - 1;
  temp2 = pivot;
  while (temp2 < temp1 && temp3 >= temp1) {
    t = *temp2;
    *temp2 = *temp3;
    *temp3 = t;
    ++temp2;
    --temp3;
  }
  lNum = (unsigned) (left - temp1);
  p_number += (unsigned)(pivot - left);
  if (p_number < lNum) {
    QSortEngine(left, p_number);
    p_number = lNum;
  }
  else {
    QSortEngine(pivot, lNum);
    pivot = left;
  }
  goto start;
}

void  quick_sort(void **pointers, int p_number, PUDC_func cmp, int width)
{
  if ((k_len = (unsigned) width) == 0)
    return;
  cmp_routine = cmp;
  QSortEngine(pointers, (unsigned) p_number);
}
