/* filename: MAKENDX1.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dos.h>
#include <share.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <limits.h>
#include <sayget.h>
#include <dbf.h>

#define SORT_POOL_MEM_SIZE 0x8000 // the default pool size for sorting
#define FRW_BUFFER_SIZE    0x8000 // file read-write buffer size

typedef struct
{
   int      ds_num; // number of the related disk spool (0-based)
   long     f_pos;  // current file position
   char    *buffer; // pointer to data read from disk
   unsigned length; // length of data read from disk
   unsigned b_pos;  // current buffer position
} MemSpool, *PMemSpool;

typedef struct
{
   int  group_len;// key group length (key_len plus 8 padded to a multiple of 4)
   int  key_len;  // length of the search key expression
   int  keys_max; // maximum number of keys per block
   PNDXBlock stack;// pseudo stack pointer: start of allocated memory for index blocks
   int  stack_height;// here is the # of (allocated) pseudo stack blocks
} ReindexData, *PReindexData;

void ExportData(void);
void quick_sort(void**, int, PUDC_func, int);

size_t      SortPoolMemPieceSize = 0;

static char *ciname;
static int   TmpHandle;
static char  tname[20];
static unsigned tlen, offset, flush_offset, flush_tlen;
static int   ndx_handle, k_len, g_len;

static PLINK     pools = 0;
static PMemSpool MPage;
static unsigned  MPageLen;
static long      FPageLen;
static int   MPageNo, FPageNo;
static char *buffer;
static int   total_ptrs, used_ptrs, mem_available = TRUE;
static long      root_num = 0L;

static PUDC_func S_cmp;
static void **S_ptrs;
static int    S_num_of_ptrs;
static int    S_num_of_pools;// number of pools
static int    S_total;       // number of entries in pool
static int    S_total_len;   // key_len + sizeof(long)

static char  *RWBuffer = 0;

static void CloseAndSetError(int error)
{
  if (TmpHandle >= 0) { // we have an open temporary file
    if (close(TmpHandle) == 0) {
      unlink(tname);
      TmpHandle = -1;
      if (error == 0)
        return;
    }
    else
      error = _doserrno;
  }
  if (!error)
    return;
  if (error == 29)
    SetError(error, 4, Disk_write_error, "\n", ciname," [MakeIndex]");
  else
    SetError(error, 2, ciname, " [MakeIndex]");
}

static int CheckDiskSpace(long r_count, int h, int k_max, int t_len)
{
  char cbuf[120];
  long total, avail;
  int  i;
  struct diskfree_t free;

  _dos_getdiskfree(0, &free);
  avail = (long) free.avail_clusters * (long) free.bytes_per_sector
        * (long) free.sectors_per_cluster;
  total = r_count * t_len; // max swap file size
  for(i = 0; i < h; i++) {
    r_count /= k_max;
    total += BLOCK_SIZE * (r_count + 1);
  }
  if (avail >= total)
    return 0;

  sprintf(cbuf, "Available disk space: %d; needed: %d\n%s [MakeIndex]",
    avail, total, ciname);
  SetError(227, 1, cbuf);
  return -1;
}

static int get_next_entry(void)
{
  long last_f_pos, f_data_left, new_rec;
  unsigned max_read, len_read;
  int low, high, pos, ret;
  char *new_data;
  MemSpool save;

  MPage->b_pos +=  S_total_len;
  if (MPage->b_pos >= MPage->length) {
    MPage->b_pos =  0;
    if (MPage->f_pos >= 0L) {
      last_f_pos = (MPage->ds_num+1) * FPageLen;
      f_data_left = last_f_pos - MPage->f_pos;
      max_read =  MPageLen;
      if ((long)MPageLen > f_data_left)
        max_read = (unsigned) f_data_left;
      lseek(TmpHandle, MPage->f_pos, 0);
      len_read = (unsigned) read(TmpHandle, MPage->buffer, max_read);
      if (len_read > max_read) // note: read returns int (-1) on error
        len_read = 0xFFFF;    // and (unsigned)(-1) is 0xFFFF
      MPage->length   =  len_read;
      MPage->f_pos +=  len_read;
      if (len_read != max_read || !len_read) {
        if (len_read % S_total_len) {
          CloseAndSetError(_doserrno);
          return -1;
        }
        MPage->f_pos = -1;
        if (!len_read) {
          --MPageNo;
          memcpy((void *)MPage, (void *)(MPage+1),MPageNo*sizeof(MemSpool));
          return 0;
        }
        else
          MPage->length = len_read;
      }
      else
        // Check if we are out of disk entries for the spool
        if (MPage->f_pos >= last_f_pos)
          MPage->f_pos = -1L;
    }
    else {
      --MPageNo;
      memcpy((void *)MPage, (void *)(MPage+1),MPageNo*sizeof(MemSpool));
      return 0;
    }
  }
  // Position the new entry to the sorted location using a binary search
  // New entry is placed before 'result':  int pos >= 1  when complete
  low   =  1;
  high  =  MPageNo;
  new_data =  MPage->buffer + MPage->b_pos;
  new_rec = *(long*) (new_data + k_len);

  for(;;) {
    pos = (low+high) / 2;
    if (pos == low && pos == high) {
      memcpy((void *)&save, (void *)MPage, sizeof(MemSpool));
      memmove(MPage, MPage+1, sizeof(MemSpool)*(pos-1));
      memcpy((void *)(MPage+pos-1), (void *)&save, sizeof(MemSpool));
      return 0;
    }
    ret = (*S_cmp)(new_data, MPage[pos].buffer + MPage[pos].b_pos, k_len);
    if (!ret)
      if (new_rec > *(long *)(MPage[pos].buffer+MPage[pos].b_pos+k_len))
        ret =  1;
    if (ret > 0)
      low = pos+1;
    else
      high = pos;
  }
}

static int flush_tmp_file(void)
{
  register int i;

  quick_sort(S_ptrs, used_ptrs, S_cmp, k_len);

  if (FPageNo++ == 0) { // first time, create a temporary file
    tmpnam(tname);
    // file doesn't exist, create it
    TmpHandle =  open(tname, (int) (O_CREAT|O_TRUNC|O_BINARY|O_RDWR)|SH_DENYNO,
              S_IREAD|S_IWRITE);
    if (TmpHandle < 0) {
      CloseAndSetError(_doserrno);
      return -1;
    }
    buffer   = RWBuffer + FRW_BUFFER_SIZE/2;
    flush_tlen  = (FRW_BUFFER_SIZE / 2 / S_total_len)*S_total_len; // normalizing
    flush_offset = 0;
  }
  for (i = 0; i < used_ptrs; i++) {
    if (flush_offset >= flush_tlen) {
      if (write(TmpHandle, buffer, flush_tlen) != (int) flush_tlen) {
        CloseAndSetError(29);
        return -1;
      }
      flush_offset = 0;
    }
    memcpy(buffer+flush_offset, S_ptrs[i], S_total_len);
    flush_offset += S_total_len;
  }
  used_ptrs = 0;
  return 0;
}

static int finish_sorting(void)
{
  void *ptr;
  int   nodes, nodes_used;
  char *pool_buffer, *pool_ptr;
  long  i;

  if (!FPageNo) // nothing is on disk
    quick_sort(S_ptrs, used_ptrs, S_cmp, k_len);
  else {
    if (flush_tmp_file())
      return -1;
    if (write(TmpHandle, buffer, flush_offset) != (int) flush_offset) {
      CloseAndSetError(29);
      return -1;
    }
    FreePtrClear((void*) &S_ptrs);
    while (1) {
      MPage =  (PMemSpool) malloc(sizeof(MemSpool) * (size_t) FPageNo);
      if (MPage)
        break;
      if (!pools) {
        CloseAndSetError(InsufficientMemory);
        return -1;
      }
      // not enough memory try to free a pool
      free(remove_from_llist(&pools));
      S_num_of_pools--;
    }
    while(1) {
      if (S_num_of_pools == 0)
        nodes =  S_total / FPageNo;
      else
        nodes =  S_total / ((FPageNo-1)/S_num_of_pools +1);
      if (!nodes)
        return -1;
      if (S_num_of_pools)
        break;
      if (allocate_and_link(&pools, SortPoolMemPieceSize))
        S_num_of_pools++;
      else {
        S_total >>= 1;
        while((ptr = remove_from_llist(&pools)) != NULL)
          free(ptr);
        pools = NULL;
        SortPoolMemPieceSize = (size_t) S_total*S_total_len+sizeof(LINK);
      }
    }
    MPageLen = nodes * S_total_len;
    FPageLen = (long) total_ptrs * S_total_len;
    nodes_used = S_total+1;
    pool_ptr = 0;
    for (i = 0L; MPageNo < FPageNo;) {
      memmove(MPage+1, MPage, sizeof(MemSpool)*MPageNo);
      if (nodes_used + nodes > S_total) {
        nodes_used =  0;
        pool_ptr= (char *) get_next_in_llist(&pools, (PLINK) pool_ptr);
        pool_buffer = pool_ptr + sizeof(LINK);
      }
      MPage->buffer =  pool_buffer;
      pool_buffer += (S_total_len*nodes);
      nodes_used  += nodes;
      MPage->ds_num =  MPageNo++;
      MPage->f_pos   =  i;
      i +=  FPageLen;
      MPage->length = 0;
      if (MPageNo < FPageNo)
        get_next_entry();
    }
  }
  return 0;
}

static int finish_writing(PReindexData reindex)
{
  int       i;
  PNode     pnode;
  PNDXBlock block = reindex->stack;

  if (offset >= tlen) { // flush buffer to disk
    if (write(ndx_handle, RWBuffer, tlen) != (int) tlen)
      goto error_msg;
    offset = 0;
  }
  memcpy(RWBuffer + offset, &reindex->stack->num_keys,BLOCK_SIZE);
  offset += BLOCK_SIZE;
  root_num++;

  for(i = 1; i < reindex->stack_height; i++) {
    block++;  // = (PNDXBlock) ((char *)block + BLOCK_SIZE);
    if (block->num_keys >= 1) {
      pnode = (PNode)((char *)block + 2*sizeof(short) + block->num_keys*g_len);
      pnode->block_num =  root_num; // just a block number
      if (offset >= tlen) { // flush buffer to disk
        if (write(ndx_handle, RWBuffer, tlen) != (int) tlen)
          goto error_msg;
        offset = 0;
      }
      memcpy(RWBuffer + offset, &block->num_keys,BLOCK_SIZE);
      offset += BLOCK_SIZE;
      root_num++;
    }
  }
  if (write(ndx_handle, RWBuffer, offset) == (int) offset)
    return 0;

error_msg:
  CloseAndSetError(29);
  return -1;
}

int build_index(PIndexType ci)
{
  PNode     pnode0, pnode1, pnode2;
  PNDXBlock leaf_block, block;
  ReindexData reindex;
  unsigned   recsize, usize;
  PUDK_func  key_maker;
  long r_count, count, recno;
  int   height, n, i, is_unique, key_counter = 0;
  int   len, pk_len, dbf_handle, user_func;
  char *SaveCurRecord;
  char *ptr, *curptr, *buf, *unused;//pointer to current available memory
  char key[101], *key_ptr;
  dbfRecord *h;
#ifndef WINDOWS
  int show;
#endif

  ciname = ci->fname;
  MPageNo = FPageNo = 0;
  total_ptrs = used_ptrs = 0;
  FPageLen = 0L;
  MPageLen = 0U;
  mem_available = TRUE;
  TmpHandle = -1;
  memset(&reindex, 0, sizeof(ReindexData));
  r_count = RecCount();
  for (height = 2; r_count != 0L; height++)
    r_count /=  ci->header.keys_max;
  reindex.stack = (PNDXBlock) malloc(BLOCK_SIZE*height);
  RWBuffer =  (char *) malloc(FRW_BUFFER_SIZE);
  if (!RWBuffer || !reindex.stack) {
    CloseAndSetError(InsufficientMemory);
    goto BAILOUT;
  }
  memset(reindex.stack, 0, BLOCK_SIZE*height);
  reindex.stack_height = height;
  memset(RWBuffer, 0, FRW_BUFFER_SIZE);
  r_count = RecNo(); // to restore position later
  Indexing = TRUE; // tell the progress bar to go half speed
  root_num = 0L;
  reindex.keys_max  =  ci->header.keys_max;
  k_len = reindex.key_len   =  ci->header.key_len;
  g_len = reindex.group_len =  ci->header.group_len;

  // now fetch keys and sort them
  S_cmp = ci->cmp;
  S_total_len = k_len + sizeof(long);
  S_total = (SORT_POOL_MEM_SIZE-sizeof(LINK)) / S_total_len;
  S_num_of_ptrs = SORT_POOL_MEM_SIZE / sizeof(char*);
  S_num_of_pools = 0;

  for(;;) {
    if ((S_ptrs = malloc(S_num_of_ptrs * sizeof(char *))) != 0)
      break;
    S_num_of_ptrs /= 2;
    if (S_num_of_ptrs < 256) {
      CloseAndSetError(InsufficientMemory);
      goto BAILOUT;
    }
  }
  memset(S_ptrs, 0, S_num_of_ptrs * sizeof(void *));

  count     = RecCount();
  recsize   = RecSize();
  pk_len    = ci->header.key_len + 1;// +1 for '\0'if string
  user_func = ci->parser ? 0 : 1;
  key_maker = ci->KeyMaker;
  h   = &WorkArea[Selected]->Handle;
  dbf_handle  = h->v.dFile; // DBF file handle
  SortPoolMemPieceSize = SORT_POOL_MEM_SIZE;

  tlen      = (FRW_BUFFER_SIZE / 2 / recsize) * recsize;// normalize tlen
  offset    = 0;

  lseek(dbf_handle, h->HeadLen, 0);
  read(dbf_handle, RWBuffer, tlen);
//  { Do not check for error here..read MAY return < tlen !!!
//    SetError(_doserrno, 1, " reading DBF file [MakeIndex]");
//    goto BAILOUT;
//  }
  if (h->DecryptProc) {
    for (i = 0; i < count; i++)
      h->DecryptProc(RWBuffer+recsize*i+1,recsize-1);
  }
  if (CheckDiskSpace(RecCount(),height, reindex.keys_max, S_total_len))
    goto BAILOUT;

#ifndef WINDOWS
  show = RotorEnabled || Odometer || (ProgressPtr != NULL);
#endif
  SaveCurRecord = h->CurRecord;
  for (recno = 1L; recno <= count; recno++) {
#ifndef WINDOWS
    if (show) {
      if (RotorEnabled)
        AdvanceRotor();
      if (ProgressPtr)
        ProgressPtr();
      if (Odometer)
        printf("\r%ld", recno);
    }
#endif
    if (offset >= tlen) {
      read(dbf_handle, RWBuffer, tlen);
      if (h->DecryptProc) {
        for (i = 0; i < count; i++)
          h->DecryptProc(RWBuffer+recsize*i+1,recsize-1);
      }
      offset = 0;
    }
    h->CurRecord = RWBuffer + offset;
    offset += recsize;
    h->CurRecNo = recno;
    if (user_func) { // user defined key maker
      ExportData();
      memcpy(key, key_maker(), pk_len);
      if (ci->SoundexFlag)
        memcpy(key, Soundex(key), pk_len);
      if (ci->Descending)
        MakeDescending(key);
      key_ptr = key;
    }
    else
      key_ptr = key_maker();
    // sort and put key
    if (used_ptrs >= total_ptrs) {
      if (used_ptrs < S_num_of_ptrs  && mem_available) {
        unused = (char *) allocate_and_link(&pools, SortPoolMemPieceSize);
        if (unused) {
          S_num_of_pools++;
          n = (SORT_POOL_MEM_SIZE-sizeof(LINK)) / S_total_len;
        }
        else { // get pointer's unused memory size
          usize = (S_num_of_ptrs-used_ptrs)*(sizeof(char *)) - (sizeof(long));
          n = usize/(sizeof(char *)+S_total_len);
          S_num_of_ptrs =  used_ptrs + n;
          unused = (char *) (S_ptrs + S_num_of_ptrs);
          mem_available = 0;
        }
        i = total_ptrs;
        total_ptrs += n;
        if (total_ptrs > S_num_of_ptrs)
          total_ptrs =  S_num_of_ptrs;
        for(; i < total_ptrs; i++, unused += S_total_len)
          S_ptrs[i] =  (void *)unused;
      }
      if (used_ptrs >= total_ptrs)
        if (flush_tmp_file()) {
          h->CurRecord = SaveCurRecord;
          goto BAILOUT;
        }
    }
    memcpy(ptr = (char *)S_ptrs[used_ptrs++], key_ptr, k_len);
    *(long*)(ptr + k_len) = recno;
  }
  h->CurRecord = SaveCurRecord;

  // write keys to file
  if (finish_sorting())
    goto BAILOUT;

  ndx_handle = ci->Ndx;
  tlen = (FRW_BUFFER_SIZE/BLOCK_SIZE) * BLOCK_SIZE; // normalize tlen
  offset = 0;
  lseek(ndx_handle, BLOCK_SIZE, 0); // skip the file header
  memset(key, 0, sizeof(key));
  is_unique =  ci->header.unique;
  for(count = 0;;) {
    if (FPageNo) { // spooling on disk was done
      if (MPageNo <= 0) {
        key_counter = 0;
        break; // no more keys
      }
      if (get_next_entry() < 0)
        goto BAILOUT;
      if (MPageNo <= 0) {
        key_counter = 0;
        break;
      }
      key_ptr = MPage->buffer+MPage->b_pos;
    }
    else {
      if (key_counter >= used_ptrs) {
        key_counter = 0;
        break;
      }
      key_ptr = (char *) S_ptrs[key_counter++];
    }
    recno = *(long*)(key_ptr+k_len);

    if (is_unique) {
      if ((*ci->cmp)(key_ptr, key, k_len) == 0)
        continue; // skip a unique key if unique flag is set
      memcpy(key, key_ptr, k_len);
    }
#ifndef WINDOWS
    if (show) {
      if (RotorEnabled)
        AdvanceRotor();
      if (ProgressPtr)
        ProgressPtr();
      if (Odometer)
        printf("\r%ld", ++count);
    }
#endif
    // put key
    block = leaf_block = reindex.stack;
    if (leaf_block->num_keys >= reindex.keys_max) {
      pnode1 = (PNode)((char*) block + 2*sizeof(short) + (block->num_keys-1) * g_len);
      for (i = 0; ; i++) {
        if (offset >= tlen) { // flush buffer to disk
          if (write(ndx_handle, RWBuffer, tlen) != (int) tlen) {
            CloseAndSetError(29);
            goto BAILOUT;
          }
          offset = 0;
        }
        memcpy(RWBuffer + offset, &block->num_keys, BLOCK_SIZE);
        offset += BLOCK_SIZE;
        if (i)
          memset(block, 0, BLOCK_SIZE);
        block++; // = (PNDXBlock) ((char *)block + BLOCK_SIZE);
        pnode2 = (PNode)((char *)block + 2*sizeof(short) + block->num_keys*g_len);
        pnode2->block_num = ++root_num;
        if (block->num_keys < reindex.keys_max) {
          block->num_keys++;
          memcpy(pnode2->Key, pnode1->Key, k_len);
          break;
        }
      }
      memset(leaf_block, 0, BLOCK_SIZE);
    }
    pnode0 = (PNode)((char *)leaf_block + 2*sizeof(short) + (leaf_block->num_keys++) * g_len);
    pnode0->DBFRecNo =  recno;
    memcpy(pnode0->Key, key_ptr, k_len);
  }
  if (finish_writing(&reindex))
    goto BAILOUT;
  ci->header.root = root_num;
  ci->header.eof = root_num + 1L;
  // assuming NDX index file header length is 512 the same as BLOCK_SIZE
  if ((buf = malloc(BLOCK_SIZE)) == 0) {
    CloseAndSetError(InsufficientMemory);
    goto BAILOUT;
  }
  curptr = memset(buf, 0, BLOCK_SIZE);
  len = sizeof(NDXHeader)-sizeof(char*); // Form the header
  // we do not need to write expression pointer here (so -4 bytes)
  memcpy(curptr, &ci->header, len);
  curptr += len;
  // now write dbf-expression
  ptr =  ci->header.expression;
  if (!ptr)
    ptr = SSI_TOKEN;
  len = strlen(ptr);
  memcpy(curptr, ptr, len);
  // all the rest of the first block is filled w/ zeros
  // curptr += len; if you want to add something else
  // Now write the header and adjust file length
  lseek(ci->Ndx, 0L, 0);
  if (write(ci->Ndx, buf, BLOCK_SIZE) < 0)
    CloseAndSetError(29);
  else
    if (chsize(ci->Ndx, ci->header.eof * BLOCK_SIZE))
      CloseAndSetError(_doserrno);
  free(buf);
  Indexing = FALSE; // reset the progress bar speed
  if (r_count)
    RawGo(r_count); // restore old position in DBF

BAILOUT:
  mem_available = TRUE;
  FreePtrClear((void*) &MPage);
  while ((ptr = remove_from_llist(&pools)) != NULL)
    free(ptr);
  FreePtrClear((void*) &S_ptrs);
  FreePtrClear((void*) &RWBuffer);
  FreePtrClear((void*) &reindex.stack);
  // exit sort, free sort data structure
  MPageNo = FPageNo = 0;
  total_ptrs = used_ptrs = 0;
  FPageLen = 0L;
  MPageLen = 0U;
  CloseAndSetError(0); // close temporary file and erase it.
  return 0;
}

#endif // NDX_TYPE
