/* filename: LEX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>

#ifdef WINDOWS
#include <windows.h>
#endif

#include <sayget.h>
#include <dbf.h>
#include <parser.h>

#define INDENT     50
#define BUFFERSIZE 256
#define POOLSIZE   512

int     _fieldno_ = 0;
int     _selectd_ = 0;
char    *_laststr_ = NULL;
double  _lastnum_ = 0.0;

static struct {
  char *keyword;
  int   token;
  int   addition_to_working_pool_size;
} _tzfar keywords[] = {
#ifdef PARSER_EXTENSIONS
  { "ACOS",      t_ACOS,        0},
  { "ASIN",      t_ASIN,        0},
  { "ATAN",      t_ATAN,        0},
  { "ATN2",      t_ATN2,        0},
  { "CEIL",      t_CEILING,     0},
  { "CEILI",     t_CEILING,     0},
  { "CEILIN",    t_CEILING,     0},
  { "CEILING",   t_CEILING,     0},
  { "COS",       t_COS,         0},
  { "DISK",      t_DISKSPACE,   0},
  { "DISKS",     t_DISKSPACE,   0},
  { "DISKSP",    t_DISKSPACE,   0},
  { "DISKSPA",   t_DISKSPACE,   0},
  { "DISKSPAC",  t_DISKSPACE,   0},
  { "DISKSPACE", t_DISKSPACE,   0},
  { "EXP",       t_EXP,         0},
  { "FIEL",      t_FIELD,      11},
  { "FIELD",     t_FIELD,      11},
  { "FILE",      t_FILE,        0},
  { "FLOO",      t_FLOOR,       0},
  { "FLOOR",     t_FLOOR,       0},
  { "GETE",      t_GETENV, STRSIZ},
  { "GETEN",     t_GETENV, STRSIZ},
  { "GETENV",    t_GETENV, STRSIZ},
  { "ISAL",      t_ISALPHA,     0},
  { "ISALP",     t_ISALPHA,     0},
  { "ISALPH",    t_ISALPHA,     0},
  { "ISALPHA",   t_ISALPHA,     0},
  { "ISLO",      t_ISLOWER,     0},
  { "ISLOW",     t_ISLOWER,     0},
  { "ISLOWE",    t_ISLOWER,     0},
  { "ISLOWER",   t_ISLOWER,     0},
  { "ISUP",      t_ISUPPER,     0},
  { "ISUPP",     t_ISUPPER,     0},
  { "ISUPPE",    t_ISUPPER,     0},
  { "ISUPPER",   t_ISUPPER,     0},
  { "LOG",       t_LOG,         0},
  { "LOG1",      t_LOG10,       0},
  { "LOG10",     t_LOG10,       0},
  { "PI",        t_PI,          0},
  { "RECC",      t_RECCOUNT,    0},
  { "RECCO",     t_RECCOUNT,    0},
  { "RECCOU",    t_RECCOUNT,    0},
  { "RECCOUN",   t_RECCOUNT,    0},
  { "RECCOUNT",  t_RECCOUNT,    0},
  { "SIGN",      t_SIGN,        0},
  { "SIN",       t_SIN,         0},
  { "SQRT",      t_SQRT,        0},
  { "TAN",       t_TAN,         0},
  { "TIME",      t_TIME,       15},
  { "TYPE",      t_TYPE,        0},
#endif
  { "ABS",       t_ABS,         0},
  { "ASC",       t_ASC,         0},
  { "AT",        t_AT,          0},
  { "CDOW",      t_CDOW,       15},
  { "CHR",       t_CHR,         2},
  { "CMON",      t_CMONTH,     15},
  { "CMONT",     t_CMONTH,     15},
  { "CMONTH",    t_CMONTH,     15},
  { "CTOD",      t_CTOD,        0},
  { "DATE",      t_DATE,        0},
  { "DAY",       t_DAY,         0},
  { "DELE",      t_DELETED,     0},
  { "DELET",     t_DELETED,     0},
  { "DELETE",    t_DELETED,     0},
  { "DELETED",   t_DELETED,     0},
  { "DOW",       t_DOW,         0},
  { "DTOC",      t_DTOC,       11},
  { "DTOR",      t_DTOR,        0},
  { "DTOS",      t_DTOS,        9},
  { "IIF",       t_IIF,    STRSIZ},
  { "INT",       t_INT,         0},
  { "LEFT",      t_LEFT,        0},
  { "LEN",       t_LEN,         0},
  { "LOWE",      t_LOWER,       0},
  { "LOWER",     t_LOWER,       0},
  { "LTRI",      t_LTRIM,       0},
  { "LTRIM",     t_LTRIM,       0},
  { "MAX",       t_MAX,         0},
  { "MIN",       t_MIN,         0},
  { "MOD",       t_MOD,         0},
  { "MONT",      t_MONTH,       0},
  { "MONTH",     t_MONTH,       0},
  { "RECN",      t_RECNO,       0},
  { "RECNO",     t_RECNO,       0},
  { "REPL",      t_REPLICATE, STRSIZ},
  { "REPLI",     t_REPLICATE, STRSIZ},
  { "REPLIC",    t_REPLICATE, STRSIZ},
  { "REPLICA",   t_REPLICATE, STRSIZ},
  { "REPLICAT",  t_REPLICATE, STRSIZ},
  { "REPLICATE", t_REPLICATE, STRSIZ},
  { "RIGH",      t_RIGHT,       0},
  { "RIGHT",     t_RIGHT,       0},
  { "ROUN",      t_ROUND,       0},
  { "ROUND",     t_ROUND,       0},
  { "RTOD",      t_RTOD,        0},
  { "RTRI",      t_RTRIM,       0},
  { "RTRIM",     t_RTRIM,       0},
  { "SOUN",      t_SOUNDEX,    15},
  { "SOUND",     t_SOUNDEX,    15},
  { "SOUNDE",    t_SOUNDEX,    15},
  { "SOUNDEX",   t_SOUNDEX,    15},
  { "SPAC",      t_SPACE,  STRSIZ},
  { "SPACE",     t_SPACE,  STRSIZ},
  { "STR",       t_STR,        30},
  { "STUF",      t_STUFF,       0},
  { "STUFF",     t_STUFF,       0},
  { "SUBS",      t_SUBSTR,      0},
  { "SUBST",     t_SUBSTR,      0},
  { "SUBSTR",    t_SUBSTR,      0},
  { "TRIM",      t_TRIM,        0},
  { "UPPE",      t_UPPER,       0},
  { "UPPER",     t_UPPER,       0},
  { "VAL",       t_VAL,         0},
  { "YEAR",      t_YEAR,        0},
  { ".F.",       t_FALSE,       0},
  { ".T.",       t_TRUE,        0},
  { ".NOT.",     t_NOT,         0},
  { ".OR.",      t_OR,          0},
  { ".AND.",     t_AND,         0},
  { "$EOT$",     t_IDENT,       0}
};

static unsigned char last_Len, last_Dec;
static unsigned WorkingPoolLen;
static PLINK    linked_list;
static char     _tzfar exprbuffer[BUFFERSIZE];
static int      exprbufferptr = 0;
static char     _tzfar parserpool[POOLSIZE];
static char    *parserpoolptr = parserpool;
static int      alias_flag;
static PLINK    conststr;

static int nextchar(int upper)
{
  int ret = EOF;

  if (exprbufferptr < BUFFERSIZE && exprbuffer[exprbufferptr] != 0)
    if (upper)
      ret = toupper(exprbuffer[exprbufferptr]);
    else
      ret = exprbuffer[exprbufferptr];
  exprbufferptr++;
  return ret;
}

static void decrement(void)
{
  if (exprbufferptr > 0)
    exprbufferptr--;
}

static int findname(char *s)
{
  int i;

  for(i=0; strcmp(keywords[i].keyword, "$EOT$"); i++)
    if (!strcmp(keywords[i].keyword, s))
      break;
  WorkingPoolLen += keywords[i].addition_to_working_pool_size;
  return keywords[i].token;
}

static int field_type(char * name)
{
  struct FieldRecord *field_on;
  int    max_field_no;
  char   alias[20], *ptr;

  if (alias_flag) {
    for(ptr = name; *ptr != '.'; ptr++) // search for '.'
      ;
    *ptr++ = 0;
    strcpy(alias, name);
    name = ptr;
    for(_selectd_=0; _selectd_ != MaxWorkAreas && WorkArea[_selectd_]; _selectd_++)
      if (!strcmp(WorkArea[_selectd_]->Alias, alias)) break;
    if (_selectd_ >= MaxWorkAreas || WorkArea[_selectd_] == NULL)
      return t_IDENT;
  }
  else
    _selectd_ = Selected;    // initialize to global

  if (WorkArea[_selectd_]) {
    max_field_no = WorkArea[_selectd_]->Handle.NumFields;
    field_on     = &(WorkArea[_selectd_]->Handle.Fields[0]);
    for(_fieldno_ = 0; _fieldno_ < max_field_no; _fieldno_++, field_on++) {
      if (strcmp(name, field_on->Name) == 0) {
        _fieldno_++;
        last_Len = (unsigned char) field_on->Len;
        switch( field_on->Typ ) {
          case 'C':
            WorkingPoolLen += (last_Len + 1);
            return alias_flag ? a_STRFIELD : t_STRFIELD;
          case 'M':
            return alias_flag ? a_MEMFIELD : t_MEMFIELD;
          case 'N':
          case 'F':
            if (last_Dec > 18)
              last_Dec = (unsigned char) field_on->Dec;
            else
              last_Dec = ParserDecimals;
            return alias_flag ? a_NUMFIELD : t_NUMFIELD;
          case 'L':
            return alias_flag ? a_LOGFIELD : t_LOGFIELD;
          case 'D':
            return alias_flag ? a_DATFIELD : t_DATFIELD;
        }
        break;
      }
    }
  }
  _fieldno_ = 0; // Error condition
  return t_IDENT;
}

static void addtopool(char ch)
{
  if(parserpoolptr - &parserpool[POOLSIZE] < 0)
    *parserpoolptr++ = ch;
  else
    *parserpoolptr = 0;
  WorkingPoolLen++;
}

int yylex(void)
{
  char ch, delimiter, *p, buf[80];
  int  token;

  alias_flag = 0;
  while(isspace(ch = nextchar(1)) && ch != EOF) ;
  if (isdigit(ch)) {
    p = buf;
    for(;;) {
      *p++ = ch;
      ch = nextchar(1);   // nnnnn[.][nn][Ennn]
      if((!isdigit(ch) && ch != '.' && ch != 'E') || ch == EOF)
        break;
    }
    *p = 0;
    decrement();
    _lastnum_ = atof(buf);
    last_Len = 0;
    last_Dec = ParserDecimals;
    return _NUMBERTYPE;
  }
  if(ch == '\'' || ch == '\"') { // 'string'  or "string"
    delimiter = ch;
    ch = nextchar(0);
    for(p = parserpoolptr; ch != delimiter; ch = nextchar(0)) {
      if (ch == EOF)
        return EOF;
      addtopool(ch);
    }
    addtopool(0);
    _laststr_ = (char *) allocate_and_link(&conststr, strlen(p)+1);
    if (_laststr_)
      strcpy(_laststr_, p);
    else {
      SetError(InsufficientMemory, 1, " [AssignExpr()]");
      return EOF;
    }
    last_Len = 0;
    last_Dec = ParserDecimals;
    return _STRINGTYPE;
  }

  if (ch == '=')
    if (nextchar(0) == '=')
      return AEQ;  // Convert == -> AEQ
    else
      decrement();
  if (ch == '*')
    if (nextchar(0) == '*')
      ch = '^';    // Convert ** -> ^
    else
      decrement();
  if (ch == '#')
    return NE;
  if (ch == '$')
    return CONTAIN;
  if (ch == '>')
    if (nextchar(0) == '=')
      return GE;
    else
      decrement();
  if (ch == '<')
    switch (nextchar(0)) {
      case '>' :
        return NE;
      case '=' :
        return LE;
      default  :
        decrement();
    }
  if (isalpha(ch) || ch == '.' || ch == '_') { // .T. .NOT. etc.
    for(p = buf; isalnum(ch) || ch == '.' || ch == '_'; ch = nextchar(1))
      *p++ = ch;
    if(ch == '-') { // check if identificator is "alias_name->field_name"
      if(nextchar(1) == '>') {
        *p++ = '.';     // if so, convert it into "alias_name.field_name"
        alias_flag = 1; // and set alias flag to TRUE
        for(ch = nextchar(1); isalnum(ch) || (ch == '_'); ch = nextchar(1))
          *p++ = ch;
      }
      else
        decrement();
    }
    *p = 0;
    decrement();
    token = field_type(buf);
    if (token != t_IDENT) { // look if function
      while(isspace(ch = nextchar(1)) && ch != EOF) ;
      if (ch == '(')
        token = t_IDENT;
      decrement();
    }
    if (token == t_IDENT) {
      last_Len = 0;
      last_Dec = ParserDecimals;
      return findname(buf);
    }
    else
      return token;
  }
  return ch;
}

static void InitLex(void)
{
  exprbufferptr = 0;
  parserpoolptr = parserpool;
  last_Len = 0;
  last_Dec = 19;
  WorkingPoolLen = 0;
  conststr = NULL;
}

static char _tzfar outbuffer[STRSIZ];

void yyerror(char *s)
{
  char chbuf;
  int  i, indent = 0;
  int  ptr    = exprbufferptr - 1;
#ifndef WINDOWS
  int skips;
#endif

  strcpy(outbuffer, s);
  strcat(outbuffer, "\n");
  if(ptr >= INDENT) {
    indent = ptr - INDENT;
#ifndef WINDOWS
    skips  = INDENT + 3;
#endif
    strcat(outbuffer, "[...");
  } else {
    indent = 0;
#ifndef WINDOWS
    skips  = ptr;
#endif
    strcat(outbuffer, "[");
  }
  i = INDENT+indent+1;
  if (i < (int)strlen(exprbuffer)) {
    chbuf =  exprbuffer[i];
    exprbuffer[i] = 0;
    strcat(outbuffer, &exprbuffer[indent]);
    strcat(outbuffer, "...]\n");
    exprbuffer[i] = chbuf;
  }
  else {
    strcat(outbuffer, &exprbuffer[indent]);
    strcat(outbuffer, "]\n");
  }
#ifndef WINDOWS
  skips ++;
  for(i = 0; i < skips; i++)
    strcat(outbuffer, " ");
  strcat(outbuffer, "^\n");
#endif
  SetError(ErrorInDBaseExpression, 1, outbuffer);
}

PParseBufferStruct AssignExpr(const char * db_expr)
{
  PParseBufferStruct handle;

  if (PARSER_errors_start <= DBFError && PARSER_errors_end >= DBFError)
    DBFError = 0; // reset previous parser errors
  handle = (PParseBufferStruct) allocate_and_link(&linked_list,
                                     sizeof(ParseBufferStruct));
  if (handle) {
    strcpy(exprbuffer, db_expr);
    InitLex();
    InitEngine(handle);
    if (yyparse()) {
      DisposeExpr(&handle);
      return NULL;
    }
    else {
      handle->conststr = conststr;
      handle->Expression = malloc(strlen(db_expr)+1);  // get memory to store expression in handle
      if (handle->Expression==NULL)
        {
          DisposeExpr(&handle);
          SetError(InsufficientMemory,3," [AssignExpr(",db_expr,")]");
          return NULL;
        }
      strcpy(handle->Expression, db_expr);  // store expression for future reference
      if (IndexRecordType == 'M') // if memo the user can change his pool size
        WorkingPoolLen = MemoGetSize;
      if (WorkingPoolLen) {
        handle->WorkingPool = malloc(WorkingPoolLen);
        if (!handle->WorkingPool) {
          DisposeExpr(&handle);
          SetError(InsufficientMemory, 1, " [AssignExpr]");
          return NULL;
        }
      }
      handle->WorkingPoolSize = WorkingPoolLen;
      handle->ReturnType = IndexRecordType;
      // expression return type
      // e.g., "recno()" returns numeric 'N'
      // "str(recno())" returns string: 'C'
      // "date()" returns data, (double, in fact): 'D'
      handle->Decimals = 0;
#ifndef DYNAMIC_TYPE
      handle->ReturnPtr = &handle->WorkStack->type;
#endif
      switch (IndexRecordType) {
        case 'M' :
          handle->ReturnPtr = handle->WorkingPool;
          handle->Length = WorkingPoolLen;
          break;
        case 'D' :
          handle->Length = 8;
          break;
        case 'C' :
          handle->ReturnPtr = handle->WorkingPool;
          if (WorkingPoolLen != last_Len + 1U)
            last_Len = 0;
          handle->Length = last_Len; // if last_Len == 0
          // if last_Len == 0 handle->length is set to illegal
          // but nothing to be done here.. we do not know real
          // length of the return string (besides it may be
          // changing, i.e. length of return string is not const)
          break;
        case 'L' :
          handle->Length = 1;
          break;
        case 'N' :
        case 'F' :
          if (last_Dec > 18) // if illegal set to default
            handle->Decimals = ParserDecimals;
          else
            handle->Decimals = last_Dec;
          if (last_Len < handle->Decimals + 2U)
            last_Len = 0;
          handle->Length = last_Len ? last_Len : (11+handle->Decimals);
          break;
      }
      return handle;
    }
  }
  else {
    SetError(InsufficientMemory, 1, " [AssignExpr()]");
    return NULL;
  }
}

void DisposeExpr(PParseBufferStruct *phandle)
{
  char *ptr = 0;
#ifdef DYNAMIC_TYPE
  void *list;
#endif

  if (phandle == NULL) return;
  while((ptr = (char *)get_next_in_llist(&linked_list, (PLINK)ptr)) != 0)
    if ((PParseBufferStruct) (ptr+sizeof(LINK)) == *phandle)
      break;
  if (ptr) {
    linked_list = (PLINK) ptr;
    ptr = (char *) remove_from_llist(&linked_list);
    if ((*phandle)->Expression)
      free((*phandle)->Expression);
    if ((*phandle)->WorkingPool)
      free((*phandle)->WorkingPool);
    while((list = remove_from_llist(&(*phandle)->conststr)) != 0)
      free(list);
#ifdef DYNAMIC_TYPE
    while((list = remove_from_llist(&(*phandle)->ss_list)) != 0)
      free(list);
    while((list = remove_from_llist(&(*phandle)->ws_list)) != 0)
      free(list);
#endif
    *phandle = NULL;
    free(ptr);
  }
}

