/* filename: INTRDATE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <sayget.h>

//  DATE CONVERSION ROUTINES
//
// NDX index file date is stored as a julian day, i.e. the
// number of days since the date  Jan 1, 4713 BC
// Ex.  Jan 1, 1981 is  2444606
// In DBF-file date is stored as a string with "YYYYMMDD" format
// Ex.  Jan 12, 1981 is  "19810112"
// In TOPAZ we use country-dependent date format and date is
// stored as a character string, so the same Jan 12, 1981 may look
// like: "12/01/81", "01/12/1981", "81.01.12", "12-01-1981" etc.
// Pretty a lot of fuss about this fusty date type.

#define  JULIAN_ADJUSTMENT    1721425L
#define  MAX_YEAR             5373484L    // 12/31/9999

typedef struct {int Mo, Day;} MoDay, * PMoDay;

static PMoDay MonthDay(int days, int if_leaf);
static long AD_days(int);
static int  day_of_year(int, int, int);
static int  AtoI(char *, int);

double DBFtoInternal(const char *dbf_type_date)
{
  int   year, month, day, day_year;
  long  total;
  char  dbf_date[9];

  memcpy(dbf_date, dbf_type_date, 8);
  *(dbf_date + 8) = 0;
  year = AtoI(dbf_date, 4);
  if (!year)
    if (memcmp(dbf_date, "        ", 8) == 0)
      return 0.0;
  month = AtoI(dbf_date+4, 2);
  day   = AtoI(dbf_date+6, 2);
  day_year = day_of_year(year, month, day);
  if (day_year < 1)
    return 0.0; // illegal date
  total =  AD_days(year);
  total+=  day_year;
  total+=  JULIAN_ADJUSTMENT;
  return (double)total;
}

double IntsToInternal(int year, int month, int day)
{
  int   day_year;
  long total;

  day_year = day_of_year(year, month, day);
  if (day_year < 1)
    return 0.0;  // illegal date
  total =  AD_days(year);
  total+=  day_year;
  total+=  JULIAN_ADJUSTMENT;
  return (double)total;
}

char * InternalToDate(double date)
{
  PMoDay ptr;
  int    year, days, day_year, is_leap;
  long total;
  static char ret[11];

  if (date > (double)MAX_YEAR)
    date = (double)MAX_YEAR;

  if ((long)date >= JULIAN_ADJUSTMENT) {
    total = (long) date - JULIAN_ADJUSTMENT;
    year = (int)(total/366);
    day_year = (int) (total - AD_days(year));
    while(day_year >
        (days=365+((year%4==0 && year%100!=0 || year%400==0)?1:0))) {
      day_year -= days;
      year++;
    }
    is_leap = (year%4 == 0 && year%100 != 0 || year%400 == 0) ? 1 : 0;
    ptr = MonthDay(day_year, is_leap);
    if (!CenturyOn)
      year %= 100;
    switch(DateFormat) {
      case American:
        sprintf(ret, CenturyOn ? "%02d/%02d/%04d" : "%02d/%02d/%02d",
        ptr->Mo, ptr->Day, year);
        break;
      case Ansi:
        sprintf(ret, CenturyOn ? "%04d.%02d.%02d" : "%02d.%02d.%02d",
        year, ptr->Mo, ptr->Day);
        break;
      case Italian:
        sprintf(ret, CenturyOn ? "%02d-%02d-%04d" : "%02d-%02d-%02d",
        ptr->Day, ptr->Mo, year);
        break;
      case French:
      case Spanish:
      case German:
        sprintf(ret, CenturyOn ? "%02d.%02d.%04d" : "%02d.%02d.%02d",
        ptr->Day, ptr->Mo, year);
        break;
      case Russian:
      case British:
        sprintf(ret, CenturyOn ? "%02d/%02d/%04d" : "%02d/%02d/%02d",
        ptr->Day, ptr->Mo, year);
        break;
    }
  }
  else {
    switch(DateFormat) {
      case American:
      case Russian:
      case British: strcpy(ret, CenturyOn ? "  /  /    " : "  /  /  "); break;
      case Ansi:    strcpy(ret, CenturyOn ? "    .  .  " : "  .  .  "); break;
      case Italian: strcpy(ret, CenturyOn ? "  -  -    " : "  -  -  "); break;
      case French:
      case Spanish:
      case German:  strcpy(ret, CenturyOn ? "  .  .    " : "  .  .  "); break;
    }
  }
  return ret;
}

char *Internal2DBF(double date)
{
  PMoDay ptr;
  int  year, days, day_year, is_leap;
  long total;
  static char ret[9];

  total = (long) date - JULIAN_ADJUSTMENT;
  if (total > 0) {
    year = (int) (total/366);
    day_year = (int) (total - AD_days(year));
    while(day_year > (days=365+((year%4==0 && year%100!=0 || year%400==0)?1:0)))
    {
      day_year -= days;
      year++;
    }
    is_leap = (year%4 == 0 && year%100 != 0 || year%400 == 0) ? 1 : 0;
    ptr = MonthDay(day_year, is_leap);
    sprintf(ret, "%04d%02d%02d", year, ptr->Mo, ptr->Day);
  }
  else
    strcpy(ret, "        ");
  return ret;
}

double CtoDInternal(const char *string_date)
{
  char date[11];
  int save, year, month, day;

  save = CenturyOn;
  CenturyOn = 1;
  memcpy(date, string_date, 10);
  *(date+10) = 0;
  Convert2American(date);
  month = AtoI(date,2);
  day   = AtoI(date+3,2);
  year  = AtoI(date+6,4);
  if (year < 100 && !*(date+8))
    year += ThisCentury(string_date);
  CenturyOn = save;
  return IntsToInternal(year, month, day);
}

static int AtoI(char * in, int width)
{
  char save;
  int  ret;

  save = in[width];
  *(in + width) = 0;
  ret = atoi(in);
  *(in + width) = save;
  return ret;
}

//  static int day_of_year(int year, int month, int day);
//  Returns an (int) day of the year starting from 1.
//  Ex. Jan 1, returns  1
//  Returns (-1) if it is an illegal date.

static int  month_tot[]=
{0, 0,  31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
// Jan Feb Mar  Apr  May  Jun   Jul  Aug  Sep  Oct  Nov  Dec
//  31  28  31   30   31   30    31   31   30   31   30   31
static int day_of_year(int year, int month, int day)
{
  int  month_days, is_leap = 0;

  if (year >= 0 && month > 0 && month < 13 && day > 0) {
    if (year%4 == 0 && year%100 != 0 || year%400 == 0)
      is_leap = 1;
    month_days = month_tot[month+1] - month_tot[month];
    if (month == 2)
      month_days += is_leap;
    if (month <= 2)
      is_leap = 0;
    if (day <= month_days)
      return month_tot[month] + day + is_leap;
  }
  return -1; // illegal date
}

static long AD_days(int yr)
{
  // Number of days from 01/01/0001 Anno Domini
  // 1) Years divisible by 400 are always leap years.
  // 2) Years divisible by 100 but not 400 are not leap years.
  // 3) Otherwise, years divisible by four are leap years.
  //    Since we do not take into account the current year,
  //    decrement year No before doing the calculation.

  if (yr--<2)
    return 0L;
  return yr*365L + yr/4L - yr/100L + yr/400L;
}

static PMoDay MonthDay(int days, int leaf)
{
  static MoDay ret;
  int month;

  if (leaf) {
    if (days > 60)
      days--;
    else
      if(days == 60) {
        ret.Mo = 2;
        ret.Day= 29;
        return &ret;
      }
  }
  for(month=1; days > month_tot[month+1]; month++) ;
  ret.Mo = month;
  ret.Day= days - month_tot[month];
  return &ret;
}
  
