/* filename: INDEXINI.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <index.h>

jmp_buf  Jumper, saveJumper; // for exception handling

PIndexType _tzfar Ind[AbsoluteMaxWorkareas][MaxOrder] = {{ 0 }};
PIndexType _tzfar SaveInd[AbsoluteMaxWorkareas][MaxOrder] = {{ 0 }};
CacheType *Cache[AbsoluteMaxWorkareas] = { 0 };
unsigned   CacheMemSize[AbsoluteMaxWorkareas]; // cache buffer size

#ifdef NDX_TYPE
void   **CachePtrs[AbsoluteMaxWorkareas] = { 0 };
int    CachePtrsCount[AbsoluteMaxWorkareas];
int    ReusableBlocks = 0;
#else
unsigned  CCacheSize[AbsoluteMaxWorkareas]; // number of nodes in Cache
unsigned  CNSize[AbsoluteMaxWorkareas]; // current node size
#endif

// let there be one node, the "PseudoNode" for each area that deals
// with the case of the DBF being one past EOF
PNode   PseudoNode[AbsoluteMaxWorkareas] = { 0 };
unsigned char OrderArray[AbsoluteMaxWorkareas];

int  SyncOrder = 0, SyncPOrder = 0;
int  IndexExact = 0;
int  Found = 0;
unsigned char   SoundexLength = 4;// adjustable with SetSoundexTo

int IndexFlushEnabled = 0;

void CloseWorkArea(int area)  // closes ALL indexes in an area
{
  int i, saveAutoHalt;

  saveAutoHalt = AutoHalt;
  AutoHalt = FALSE;
  ZerOrder[area] = 0;

  for (i = 0; i < MaxOrder; i++) {
    DBFError = 0;
    CloseOneIndex(area, i);
  }
  OrderArray[area] = 0;
  AutoHalt = saveAutoHalt;
}

void IndexExit(void)
{
  int i, savearea;

  // if the CloseDatabases() function has not been called
  // then we have to close the indexes here
  savearea = Selected;
  if (!setjmp(Jumper))
    for (i = 0; i < MaxWorkAreas; i++) {
      Selected = i;
      CloseWorkArea(i);
    }
  Selected = savearea;
}

void assertJumper(void)
{
  if (!AutoHalt)
    longjmp(Jumper, 1);
}

void TZIndexInit(void)
{
  IndexPresent = TRUE;
  atexit(IndexExit);

  if (setjmp(Jumper))
    exit(555);

  IndexRoutines.FindProc          = Find;
  IndexRoutines.IndexOpenFunc     = IndexOpenFunc;
  IndexRoutines.FindFirstRecFunc  = FindFirstRecFunc;
  IndexRoutines.FindLastRecFunc   = FindLastRecFunc;
  IndexRoutines.IEofFunc          = IEOFFunc;
  IndexRoutines.IBofFunc          = IBOFFunc;
  IndexRoutines.IndexNameProc     = IndexName;
  IndexRoutines.CloseSelectedProc = CloseIndexes;
  IndexRoutines.StoreCurrentKeys  = StoreCurrentKeys;
  IndexRoutines.AppendNewKey      = AppendNewKey;
  IndexRoutines.KeyMakerFunc      = KeyMakerFunc;
  IndexRoutines.SetBofFlagProc    = SetBOFFlagProc;
  IndexRoutines.SetEofFlagProc    = SetEOFFlagProc;
  IndexRoutines.FoundVar          = &Found;
  IndexRoutines.ReindexProc       = Reindex;
  IndexRoutines.SortOrderFlag     = SortOrderFlag;
  IndexRoutines.SoundexFlag       = SoundexFlag;
  IndexRoutines.FindNextRecFunc   = FindNextRecFunc;
  IndexRoutines.FindPriorRecFunc  = FindPriorRecFunc;
  IndexRoutines.CompareKeys       = CompareKeys;
  IndexRoutines.SyncIndexProc     = SyncIndexProc;
#ifdef NET
  IndexRoutines.SetReadSemaphoreProc = SetReadSemaphoreProc;
  IndexRoutines.SetLockSemaphoreProc = SetLockSemaphoreProc;
#endif
}
