/* filename: GETNSIZE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifndef NDX_TYPE
#include <stdlib.h>
#include <string.h>
#include <share.h>

unsigned GetNodeSize(const char *filename, char * s)
{// gets the size of record in the .IND file
  FILE * f;
  unsigned char keysize;
  char   sbuf[STRSIZ];

  DBFError = 0;

#ifdef NET
  if (MultiUser)
    f = _fsopen(filename, "rb+", SH_DENYNO);
  else
#endif
    f = fopen(filename, "rb+");

  if (f) {
     // Skip: unsigned Version; long FirstRec; long LastRec;
     // and read: unsigned char KeyLength; into keysize
    fseek(f, (long)(sizeof(unsigned) + 2 * sizeof(long)), SEEK_SET);
    if (fread(&keysize, 1, sizeof(char), f) == sizeof(char)) {
      if (fclose(f) == 0) {
        // add 21 bytes --  20 for 5 long integers
        // plus the end zero-byte of the key string
        return (unsigned)keysize + 21U;
      }
      DBFError = _doserrno;
      sprintf(sbuf, "%s%s", error_closing_index_file, filename);
    }
    else {
      DBFError = _doserrno;
      sprintf(sbuf, "%s%s", error_reading_index_file, filename);
      fclose(f);
    }
  }
  else {
    DBFError = _doserrno;
    sprintf(sbuf,"%s%s%s",unable_to_open_index,filename,unable_to_open_index2);
  }

  sbuf[79] = 0;
  strcpy(s, sbuf);
  return 0U;
}
#endif // NDX_TYPE
