/* filename: FINDPREV.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <dbf.h>
#include <index.h>

#ifdef NDX_TYPE
extern int OrderChanged;

long FindPriorRecFunc(void) // _FindPriorRec, FindPriorRec, SkipBackward
{
  PIndexType p;
  PNode pi;
  long  savelong;
  int   order, savecurrnode;

  Found = FALSE;

#ifdef NET
#ifdef NETLOG
  WriteLog("Skip(-1)");
#endif
  CheckForChange();
#endif

  order = SyncOrder;
  p = Ind[Selected][order];
  pi = p->Index;
  savelong  = p->currblock;
  savecurrnode = p->currnode;
  p->EOFFlag = FALSE;
  if (!RecCount()) { // can this ever happen ?
    p->EOFFlag = p->BOFFlag = TRUE;
    return 0L;
  }
  if (ZerOrder[Selected]) {
    savelong = RecNo();
    if (savelong > 1) // check for BOF
      --savelong;
    return savelong;
  }
  if (pi->DBFRecNo == -1) { // PseudoNode indicator
    GetNode(savelong, order);
    p->Index = (PNode)((char *)p->Index + savecurrnode * p->header.group_len);
    p->currnode = savecurrnode;
    return p->Index->DBFRecNo;
  }
  if (p->BOFFlag)
    return pi->DBFRecNo;
  savelong = pi->DBFRecNo;
  if (OrderChanged) {
    _Find(p->KeyStorage); // update path if changed
    if (p->EOFFlag)
      FindLastRecFunc();
    else {
      while(savelong != p->Index->DBFRecNo && !p->EOFFlag)
        FindNextRecFunc();
      if (p->EOFFlag) {
        SetError(254, 1, " [FindPrevRecFunc]"); // this should not ever happen
        _Find(p->KeyStorage);
      }
    }
    pi = p->Index;
  }
  if (savecurrnode) {
    --p->currnode;
    p->Index = (PNode)((char *)p->Index - p->header.group_len);
  }
  else {
    if (up_path_prev(order) == 0L) { // root
      if (savelong == FindFirstRecFunc())
        p->BOFFlag = TRUE;
      return p->Index->DBFRecNo;
    }
  }
  Found = !p->BOFFlag;
  return p->Index->DBFRecNo;
}

#else // NDX_TYPE

long FindPriorRecFunc(void) // _FindPriorRec, FindPriorRec, SkipBackward
{
  char  StartingKey[101];
  Node  StartingNode;
  Node  LastValidNode;
  int   order;
  PNode pi;
  long  savelong;
  PIndexType   p;

#ifdef NET
#ifdef NETLOG
  WriteLog("Skip(-1)");
#endif
  CheckForChange();
#endif

  order = SyncOrder;
  p = Ind[Selected][order];
  pi = p->Index;
  if (!RecCount()) { // can this ever happen?
    p->EOFFlag = TRUE;
    p->BOFFlag = TRUE;
    return pi->DBFRecNo;
  }
  if (ZerOrder[Selected]) {
    savelong = RecNo();
    if (savelong > 1) // check for BOF
      --savelong;
    return savelong;
  }
  p->BOFFlag = pi->DBFRecNo == p->Anchor.FirstRec;
  p->EOFFlag = FALSE;
  if (p->BOFFlag)
    return pi->DBFRecNo;
  LastValidNode = *pi;

LOOP:
  if (pi->LessNode > 0) {
    GetNode(pi->LessNode,order);
    pi = p->Index; // GetNode sets a new p->Index !
    if (pi->DBFRecNo > 0)
      LastValidNode = *pi;
    while (pi->GrtrNode > 0) {
      GetNode(pi->GrtrNode,order);
      pi = p->Index;
      if (pi->DBFRecNo > 0)
        LastValidNode = *pi;
    }
    if (pi->DBFRecNo > 0)
      return pi->DBFRecNo;
    else
      goto LOOP;
  }
  else {
    if (pi->PreviousNode > 0) {
      if (pi->DBFRecNo > 0) {
        memcpy(&StartingNode,pi,sizeof(Node));
        strcpy(StartingKey,pi->Key);
      }
      else {
        if (pi->Entry == -1) { // we are at the pseudonode..backup to previous node and exit
          GetNode(pi->PreviousNode,order);
          pi = p->Index;
          return pi->DBFRecNo;
        }
        else {
          memcpy(&StartingNode,&LastValidNode,sizeof(Node));
          strcpy(StartingKey,LastValidNode.Key);
        }
      }
      do {
        GetNode(pi->PreviousNode,order);
        pi = p->Index;
        if (pi->DBFRecNo > 0)
          memcpy(&LastValidNode,pi,sizeof(Node));
      } while (!((pi->PreviousNode == 0) || (strcmp(StartingKey,pi->Key) >= 0)));
      if (strcmp(StartingKey,pi->Key) >= 0)
        return pi->DBFRecNo;
      else {
        GetNode(StartingNode.Entry,order);
        pi = p->Index;
        return pi->DBFRecNo;
      }
    }
    else
      return pi->DBFRecNo;
  }
}
#endif // NDX_TYPE

