/* filename: FINDNEXT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <dbf.h>
#include <index.h>

#ifdef NDX_TYPE
extern int OrderChanged;
#endif

long FindNextRecFunc(void) // FindNextRec, _FindNextRec, SkipForward
{
  int        order;
  PIndexType p;
  PNode      pi;
  long       savelong;

#ifndef NDX_TYPE
  char StartingKey[101];
  Node StartingNode, LastValidNode;
#else
  Found = FALSE;
#endif

#ifdef NET
#ifdef NETLOG
  WriteLog("SKIP 1");
#endif
  CheckForChange();
#endif

  order = SyncOrder;
  p = Ind[Selected][order];
  pi = p->Index;
  if (!RecCount()) {//  could this ever happen ?
    p->EOFFlag = p->BOFFlag = TRUE;
    return pi->DBFRecNo;
  }
  if (ZerOrder[Selected]) {
    savelong = RecNo();
    if (savelong < RecCount())  // check for EOF
      ++savelong;
    return savelong;
  }
  p->BOFFlag = FALSE;
#ifdef NDX_TYPE
  if (p->EOFFlag) {
    savelong = FindLastRecFunc();
    SetPseudoNode(Selected, 0);
    p->EOFFlag = 1;
    return savelong;
  }
  savelong = pi->DBFRecNo;
  if (OrderChanged) {
    _Find(p->KeyStorage); // update path if changed
    if (p->EOFFlag)
      FindLastRecFunc();
    else {
      while(savelong != p->Index->DBFRecNo && !p->EOFFlag)
        FindNextRecFunc();
      if (p->EOFFlag) {
        SetError(254, 1, " [FindNextRecFunc]"); // this should not ever happen
        _Find(p->KeyStorage);
      }
    }
    pi = p->Index;
  }
  if (p->BlockBufferPtr->num_keys > p->currnode+1) {
    ++p->currnode;
    p->Index = (PNode)((char *)p->Index + p->header.group_len);
  }
  else
    if (!up_path_next(order)) { // root
      if (savelong == FindLastRecFunc())
        p->EOFFlag = TRUE;
      return p->Index->DBFRecNo;
    }
  Found = !p->EOFFlag;// seems always true to me
  return p->Index->DBFRecNo;
}

#else
  p->EOFFlag = pi->DBFRecNo == p->Anchor.LastRec;
  if (p->EOFFlag)
    return pi->DBFRecNo;
  LastValidNode = *pi;

LOOP:
  if (pi->GrtrNode > 0) {
    GetNode(pi->GrtrNode,order);
    pi = p->Index;
    if (pi->DBFRecNo > 0)
      LastValidNode = *pi;
    while (pi->LessNode > 0) {
      GetNode(pi->LessNode,order);
      pi = p->Index;
      if (pi->DBFRecNo > 0)
        LastValidNode = *pi;
    }
    if (pi->DBFRecNo > 0)
      return pi->DBFRecNo;
    else
      goto LOOP;
  }
  else {
    if (pi->PreviousNode > 0) {
      if (pi->DBFRecNo > 0) {
        memcpy(&StartingNode,pi,sizeof(Node));
        strcpy(StartingKey,pi->Key);
      }
      else {
        memcpy(&StartingNode,&LastValidNode,sizeof(Node));
        strcpy(StartingKey,LastValidNode.Key);
      }
      do {
        GetNode(pi->PreviousNode,order);
        pi = p->Index;
        if (pi->DBFRecNo > 0)
          memcpy(&LastValidNode,pi,sizeof(Node));
      } while (pi->PreviousNode && (strcmp(StartingKey,pi->Key) >= 0));
      if (strcmp(StartingKey,pi->Key) <= 0)
        return pi->DBFRecNo;
      else {
        GetNode(StartingNode.Entry,order);
        return p->Index->DBFRecNo;
      }
    }
    else
      return pi->DBFRecNo;
  }
}
#endif // NDX_TYPE
