/* filename: FINDNEAR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <index.h>

void FindNear(const char * key)
{
  void (*SaveSyncProcPtr)(void);

#ifdef NDX_TYPE
  PIndexType p;
  int        saveExact;

  Found = FALSE;
  if (!*Trim(key))
    return;
  // if there is a relation set, we need to save the pointer
  // and UNset the relation..it's wasteful to be thrashing around
  // syncing dbfs in the middle of this process..also,
  // the index node pointer will get corrupted
  SaveSyncProcPtr = GetSyncProcPtr();
  SetSyncProcPtr(NULL);
  // now proceed to do a normal FIND
  saveExact = IndexExact;
  IndexExact = FALSE;
  FindingEdge = TRUE;
  Find(key);
  FindingEdge = FALSE;
  IndexExact = saveExact;
  SetSyncProcPtr(SaveSyncProcPtr);
  p = Ind[Selected][0];
  if (p->Index->DBFRecNo && SaveSyncProcPtr) // if there is a relation, sync things up
    RawGo(p->Index->DBFRecNo);
  StoreCurrentKeys();
}

#else

  long TargetRec;
  int  validRec;
  long LastValidRec;
  PIndexType p;
  PNode      pi;
  char       k[101];

  memcpy(k, Trim(key), 100);
  *(k + 100) = 0;
  Found = FALSE;
  if(!*k)
    return;
  // if there is a relation set, we need to save the pointer and UNset the
  // relation..it's wasteful to be thrashing around syncing dbfs in the
  // middle of this process..also, the index node pointer will get corrupted
  SaveSyncProcPtr = GetSyncProcPtr();
  SetSyncProcPtr(NULL);
  // now proceed to do a normal Find()
  InhibitGo = TRUE;
  FindingEdge = TRUE;
  Find(k); // first, try to find the key exactly..but notice that with
  // FindingEdge and InhibitGo TRUE, we will stop at a close node
  InhibitGo = FALSE;
  p = Ind[Selected][0];
  pi = p->Index;
  TargetRec = pi->DBFRecNo; // this is a leaf if not found
  if (Found) {
    RawGo(TargetRec);   // go to the record
    validRec = ValidRec();
  }
  else
    validRec = TRUE;
  if (!(Found && validRec)) {
    if (p->SoundexFlag)
      strcpy(k,Soundex(k));
    if (p->Descending)
      MakeDescending(k);
    if ((strcmp(pi->Key,k) < 0) || (!validRec)) {// key i found is too small..go forward until just past key I want
      do {
        LastValidRec = TargetRec;
        TargetRec = FindNextRecFunc();
        pi = p->Index;
        RawGo(TargetRec); // go to the record
        validRec = ValidRec();
      } while (!(((strcmp(pi->Key,k) > 0) && validRec) || (p->EOFFlag)));
    }
    else {// key I found is too big..back up until its too small,
      // and go forward 1 record
      do {
        LastValidRec = TargetRec;
        TargetRec = FindPriorRecFunc();
        pi = p->Index;
        RawGo(TargetRec);   // go to the record
        validRec = ValidRec();
      }  while (!(((strcmp(pi->Key,k) < 0) && validRec) || (p->BOFFlag)));
      // watch for the case of bumping into BOF, and the key is STILL too big
      if (strcmp(pi->Key,k) < 0) {// go forward one valid record..and i know there is one
        do {
          LastValidRec = TargetRec;
          TargetRec = FindNextRecFunc();
          pi = p->Index;
          RawGo(TargetRec);   // go to the record
          validRec = ValidRec();
        }  while (!(((strcmp(pi->Key,k) > 0) && validRec) || (p->EOFFlag)));
      }
    }
    if (p->EOFFlag && !validRec) {
      RawGo(LastValidRec);
      if (!validRec) {// go bottom and skip 1 to get us past EOF
        SetEOF();
        TargetRec = RecCount() + 1L;
      }
    }
  }
  FindingEdge = FALSE;   // set this back to normal, too
  SetSyncProcPtr(SaveSyncProcPtr); // now restore the relation
  if (SaveSyncProcPtr) // if there is a relation, sync things up
    RawGo(TargetRec);
  StoreCurrentKeys();
}
#endif //NDX_TYPE
  
