/* filename: EXTRA.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dbf.h>
  
int ParserDecimals = 2;  // default width for decimals
  
static void memrev(char *buf, size_t count)
{
  char *r;
  for (r = buf + count - 1; buf < r; buf++, r--) {
    *buf ^= *r;
    *r   ^= *buf;
    *buf ^= *r;
  }
}
  
void aswap(char  *buf, size_t head, size_t tail)
{ //  swap "head" bytes with "tail" bytes at "buf"
  memrev(buf, head);
  memrev(buf + head, tail);
  memrev(buf, head + tail);
}
  
void * DBF_field_address(int field_no, void * buf_ptr, int workarea)
{
  char S[21];
  static int n;
  static long l;
  static double d;
  dbfRecord    *h;
  FieldRecord  *f;
  
  if (workarea >= MaxWorkAreas)
    workarea = Selected;
  h = &(WorkArea[workarea]->Handle);
  field_no--; // make it 0-based
  if (h->v.strue.LinkedList)
    return NULL;
  f = &h->Fields[0];
  for (n = 0; n < field_no; n++, f++) ;
  switch (f->Typ) {
    case 'C' ://  character field
      memcpy(buf_ptr, &h->CurRecord[f->Off], f->Len);
      *((char *)buf_ptr + f->Len) = 0;
      return buf_ptr;
    case 'M' ://  memo field
      memcpy(S, &h->CurRecord[f->Off], f->Len);
      *(S + f->Len) = 0;
      l = strtol(S, NULL, 10);
      return &l;
    case 'D' ://  date field
      return &h->CurRecord[f->Off];
    case 'L' :// logical field
      n = (int) *(char*)&h->CurRecord[f->Off];
      n = strchr("YyTt", n) ? 1 : 0;
      return &n;
    case 'N' : //  "numeric" and "float" fields
    case 'F' :
      memcpy(S, &h->CurRecord[f->Off], f->Len);
      *(S + f->Len) = 0;
      d = strtod(S, NULL);
      return &d;
  }
  return NULL;
}
  
void SetDecimalsTo(int decimals)
{
  if (decimals >= 0 && decimals < 19) // 0..18 are valid
    ParserDecimals = decimals;
}
  
  
